/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.titan.runtime.core.TTCN_Logger;
import org.eclipse.titan.runtime.core.TitanCharString;
import org.eclipse.titan.runtime.core.TitanCharString_Element;
import org.eclipse.titan.runtime.core.TitanInteger;
import org.eclipse.titan.runtime.core.TitanUniversalChar;
import org.eclipse.titan.runtime.core.TitanUniversalCharString;
import org.eclipse.titan.runtime.core.TtcnError;

public class TitanUniversalCharString_Element {
    private boolean bound_flag;
    private final TitanUniversalCharString str_val;
    private final int char_pos;

    public TitanUniversalCharString_Element(boolean par_bound_flag, TitanUniversalCharString par_str_val, int par_char_pos) {
        this.bound_flag = par_bound_flag;
        this.str_val = par_str_val;
        this.char_pos = par_char_pos;
    }

    public boolean is_bound() {
        return this.bound_flag;
    }

    public boolean is_present() {
        return this.bound_flag;
    }

    public boolean is_value() {
        return this.bound_flag;
    }

    public void must_bound(String errorMessage) {
        if (!this.bound_flag) {
            throw new TtcnError(errorMessage);
        }
    }

    public TitanUniversalCharString_Element operator_assign(TitanUniversalCharString_Element otherValue) {
        otherValue.must_bound("Assignment of an unbound universal charstring element.");
        if (otherValue != this) {
            this.bound_flag = true;
            if (this.str_val.charstring) {
                if (otherValue.str_val.charstring) {
                    this.str_val.cstr.setCharAt(this.char_pos, otherValue.get_char().getUc_cell());
                } else {
                    this.str_val.convert_cstr_to_uni();
                    this.str_val.val_ptr.set(this.char_pos, otherValue.get_char());
                }
            } else if (otherValue.str_val.charstring) {
                this.str_val.val_ptr.set(this.char_pos, new TitanUniversalChar('\u0000', '\u0000', '\u0000', otherValue.str_val.cstr.charAt(otherValue.char_pos)));
            } else {
                this.str_val.val_ptr.set(this.char_pos, otherValue.get_char());
            }
        }
        return this;
    }

    public TitanUniversalCharString_Element operator_assign(TitanUniversalCharString otherValue) {
        int length;
        otherValue.must_bound("Assignment of an unbound universal charstring value to a universal charstring element.");
        int n = length = otherValue.charstring ? otherValue.cstr.length() : otherValue.val_ptr.size();
        if (length != 1) {
            throw new TtcnError("Assignment of a universal charstring value with length other than 1 to a universal charstring element.");
        }
        this.bound_flag = true;
        this.operator_assign(otherValue.constGet_at(0));
        return this;
    }

    public TitanUniversalCharString_Element operator_assign(TitanUniversalChar otherValue) {
        this.bound_flag = true;
        if (this.str_val.charstring) {
            if (otherValue.is_char()) {
                this.str_val.cstr.setCharAt(this.char_pos, otherValue.getUc_cell());
                return this;
            }
            this.str_val.convert_cstr_to_uni();
        }
        this.str_val.val_ptr.set(this.char_pos, otherValue);
        return this;
    }

    public TitanUniversalCharString_Element operator_assign(String otherValue) {
        if (otherValue == null || otherValue.length() != 1) {
            throw new TtcnError("Assignment of a charstring value with length other than 1 to a universal charstring element.");
        }
        this.bound_flag = true;
        if (this.str_val.charstring) {
            this.str_val.cstr.setCharAt(this.char_pos, otherValue.charAt(0));
        } else {
            this.str_val.val_ptr.set(this.char_pos, new TitanUniversalChar('\u0000', '\u0000', '\u0000', otherValue.charAt(0)));
        }
        return this;
    }

    public TitanUniversalCharString_Element operator_assign(TitanCharString otherValue) {
        otherValue.must_bound("Assignment of an unbound charstring value to a universal charstring element.");
        if (otherValue.lengthof().get_int() != 1) {
            throw new TtcnError("Assignment of a charstring value with length other than 1 to a universal charstring element.");
        }
        this.bound_flag = true;
        if (this.str_val.charstring) {
            this.str_val.cstr.setCharAt(this.char_pos, otherValue.get_at(0).get_char());
        } else {
            this.str_val.val_ptr.set(this.char_pos, new TitanUniversalChar('\u0000', '\u0000', '\u0000', otherValue.get_at(0).get_char()));
        }
        return this;
    }

    public TitanUniversalCharString_Element operator_assign(TitanCharString_Element otherValue) {
        otherValue.must_bound("Assignment of an unbound charstring element to a universal charstring element.");
        this.bound_flag = true;
        if (this.str_val.charstring) {
            this.str_val.cstr.setCharAt(this.char_pos, otherValue.get_char());
        } else {
            this.str_val.val_ptr.set(this.char_pos, new TitanUniversalChar('\u0000', '\u0000', '\u0000', otherValue.get_char()));
        }
        return this;
    }

    public boolean operator_equals(TitanUniversalCharString_Element otherValue) {
        this.must_bound("Unbound left operand of charstring element comparison.");
        otherValue.must_bound("Unbound right operand of charstring comparison.");
        return this.get_char().operator_equals(otherValue.get_char());
    }

    public boolean operator_equals(TitanUniversalCharString otherValue) {
        this.must_bound("Unbound left operand of charstring element comparison.");
        otherValue.must_bound("Unbound right operand of charstring element comparison.");
        if (otherValue.get_value().size() != 1) {
            return false;
        }
        return this.get_char().operator_equals(otherValue.char_at(0));
    }

    public boolean operator_equals(TitanUniversalChar otherValue) {
        this.must_bound("The left operand of comparison is an unbound universal charstring element.");
        if (this.str_val.charstring && otherValue.is_char()) {
            return this.str_val.cstr.charAt(this.char_pos) == otherValue.getUc_cell();
        }
        if (this.str_val.charstring && !otherValue.is_char()) {
            return false;
        }
        if (!this.str_val.charstring && otherValue.is_char()) {
            TitanUniversalChar uchar = new TitanUniversalChar(this.str_val.char_at(this.char_pos));
            return uchar.getUc_group() == '\u0000' && uchar.getUc_plane() == '\u0000' && uchar.getUc_row() == '\u0000' && uchar.getUc_cell() == otherValue.getUc_cell();
        }
        return this.str_val.val_ptr.get(this.char_pos).operator_equals(otherValue);
    }

    public boolean operator_equals(String otherValue) {
        this.must_bound("The left operand of comparison is an unbound universal charstring element.");
        if (otherValue == null || otherValue.length() != 1) {
            return false;
        }
        if (this.str_val.charstring) {
            return this.str_val.cstr.charAt(this.char_pos) == otherValue.charAt(0);
        }
        TitanUniversalChar uc = this.str_val.val_ptr.get(this.char_pos);
        return uc.getUc_group() == '\u0000' && uc.getUc_plane() == '\u0000' && uc.getUc_row() == '\u0000' && uc.getUc_cell() == otherValue.charAt(0);
    }

    public boolean operator_equals(TitanCharString otherValue) {
        this.must_bound("The left operand of comparison is an unbound universal charstring element.");
        otherValue.must_bound("The right operand of comparison is an unbound charstring value.");
        if (otherValue.lengthof().get_int() != 1) {
            return false;
        }
        if (this.str_val.charstring) {
            return this.str_val.cstr.charAt(this.char_pos) == otherValue.get_at(0).get_char();
        }
        TitanUniversalChar uchar = this.str_val.val_ptr.get(this.char_pos);
        return uchar.getUc_group() == '\u0000' && uchar.getUc_plane() == '\u0000' && uchar.getUc_row() == '\u0000' && uchar.getUc_cell() == otherValue.get_at(0).get_char();
    }

    public boolean operator_equals(TitanCharString_Element otherValue) {
        this.must_bound("The left operand of comparison is an unbound universal charstring element.");
        otherValue.must_bound("The right operand of comparison is an unbound charstring element.");
        if (this.str_val.charstring) {
            return this.str_val.cstr.charAt(this.char_pos) == otherValue.get_char();
        }
        TitanUniversalChar uchar = this.str_val.val_ptr.get(this.char_pos);
        return uchar.getUc_group() == '\u0000' && uchar.getUc_plane() == '\u0000' && uchar.getUc_row() == '\u0000' && uchar.getUc_cell() == otherValue.get_char();
    }

    public boolean operator_not_equals(TitanUniversalCharString_Element otherValue) {
        return !this.operator_equals(otherValue);
    }

    public boolean operator_not_equals(TitanUniversalCharString otherValue) {
        return !this.operator_equals(otherValue);
    }

    public boolean operator_not_equals(TitanUniversalChar otherValue) {
        return !this.operator_equals(otherValue);
    }

    public boolean operator_not_equals(String otherValue) {
        return !this.operator_equals(otherValue);
    }

    public boolean operator_not_equals(TitanCharString otherValue) {
        return !this.operator_equals(otherValue);
    }

    public boolean operator_not_equals(TitanCharString_Element otherValue) {
        return !this.operator_equals(otherValue);
    }

    public TitanUniversalCharString operator_concatenate(TitanUniversalChar other_value) {
        this.must_bound("The left operand of concatenation is an unbound universal charstring element.");
        if (this.str_val.charstring && other_value.is_char()) {
            TitanUniversalCharString result = new TitanUniversalCharString();
            result.cstr = new StringBuilder();
            result.cstr.append(this.str_val.cstr.charAt(this.char_pos));
            result.cstr.append(other_value.getUc_cell());
            result.charstring = true;
            return result;
        }
        if (this.str_val.charstring ^ other_value.is_char()) {
            TitanUniversalCharString result = new TitanUniversalCharString();
            result.val_ptr = new ArrayList<TitanUniversalChar>(2);
            result.charstring = false;
            if (this.str_val.charstring) {
                result.val_ptr.add(new TitanUniversalChar('\u0000', '\u0000', '\u0000', this.str_val.cstr.charAt(this.char_pos)));
            } else {
                result.val_ptr.add(this.str_val.val_ptr.get(this.char_pos));
            }
            result.val_ptr.add(other_value);
            return result;
        }
        TitanUniversalCharString result = new TitanUniversalCharString();
        result.val_ptr = new ArrayList<TitanUniversalChar>(2);
        result.val_ptr.add(this.str_val.val_ptr.get(this.char_pos));
        result.val_ptr.add(other_value);
        result.charstring = false;
        return result;
    }

    public TitanUniversalCharString operator_concatenate(String other_value) {
        this.must_bound("The left operand of concatenation is an unbound universal charstring element.");
        if (other_value == null) {
            return new TitanUniversalCharString(this.str_val.char_at(this.char_pos));
        }
        TitanUniversalCharString result = new TitanUniversalCharString();
        if (this.str_val.charstring) {
            result.cstr = new StringBuilder();
            result.cstr.append(this.str_val.cstr.charAt(this.char_pos));
            result.cstr.append(other_value);
            result.charstring = true;
        } else {
            result.val_ptr = new ArrayList<TitanUniversalChar>();
            result.charstring = false;
            result.val_ptr.add(this.get_char());
            for (int i = 0; i < other_value.length(); ++i) {
                result.val_ptr.add(new TitanUniversalChar('\u0000', '\u0000', '\u0000', other_value.charAt(i)));
            }
        }
        return result;
    }

    public TitanUniversalCharString operator_concatenate(TitanCharString other_value) {
        this.must_bound("The left operand of concatenation is an unbound universal charstring element.");
        other_value.must_bound("The right operand of concatenation is an unbound charstring value.");
        TitanUniversalCharString result = new TitanUniversalCharString();
        if (this.str_val.charstring) {
            result.cstr = new StringBuilder();
            result.cstr.append(this.str_val.cstr.charAt(this.char_pos));
            for (int i = 0; i < other_value.lengthof().get_int(); ++i) {
                result.cstr.append(other_value.get_at(i).get_char());
            }
            result.charstring = true;
        } else {
            result.val_ptr = new ArrayList<TitanUniversalChar>();
            result.val_ptr.add(0, this.str_val.val_ptr.get(this.char_pos));
            for (int i = 0; i < other_value.lengthof().get_int(); ++i) {
                result.val_ptr.add(new TitanUniversalChar('\u0000', '\u0000', '\u0000', other_value.get_at(i).get_char()));
            }
            result.charstring = false;
        }
        return result;
    }

    public TitanUniversalCharString operator_concatenate(TitanCharString_Element other_value) {
        this.must_bound("The left operand of concatenation is an unbound universal charstring element.");
        other_value.must_bound("The right operand of concatenation is an unbound charstring element.");
        TitanUniversalCharString result = new TitanUniversalCharString();
        if (this.str_val.charstring) {
            result.cstr = new StringBuilder();
            result.charstring = true;
            result.cstr.append(this.str_val.cstr.charAt(this.char_pos));
            result.cstr.append(other_value.get_char());
        } else {
            result.val_ptr = new ArrayList<TitanUniversalChar>(2);
            result.charstring = false;
            result.val_ptr.add(this.str_val.val_ptr.get(this.char_pos));
            result.val_ptr.add(new TitanUniversalChar('\u0000', '\u0000', '\u0000', other_value.get_char()));
        }
        return result;
    }

    public TitanUniversalCharString operator_concatenate(TitanUniversalCharString other_value) {
        this.must_bound("The left operand of concatenation is an unbound universal charstring element.");
        other_value.must_bound("The right operand of concatenation is an unbound universal charstring value.");
        TitanUniversalCharString result = new TitanUniversalCharString();
        if (this.str_val.charstring) {
            if (other_value.charstring) {
                result.charstring = true;
                result.cstr = new StringBuilder();
                result.cstr.append(this.str_val.cstr.charAt(this.char_pos));
                result.cstr.append((CharSequence)other_value.cstr);
            } else {
                result.charstring = false;
                result.val_ptr = new ArrayList<TitanUniversalChar>();
                result.val_ptr.add(new TitanUniversalChar('\u0000', '\u0000', '\u0000', this.str_val.cstr.charAt(this.char_pos)));
                result.val_ptr.addAll(other_value.val_ptr);
            }
        } else {
            result.charstring = false;
            result.val_ptr = new ArrayList<TitanUniversalChar>();
            result.val_ptr.add(this.str_val.val_ptr.get(this.char_pos));
            if (other_value.charstring) {
                for (int i = 0; i < other_value.val_ptr.size(); ++i) {
                    result.val_ptr.add(new TitanUniversalChar('\u0000', '\u0000', '\u0000', other_value.cstr.charAt(i)));
                }
            } else {
                result.val_ptr.addAll(other_value.val_ptr);
            }
        }
        return result;
    }

    public TitanUniversalCharString operator_concatenate(TitanUniversalCharString_Element other_value) {
        this.must_bound("The left operand of concatenation is an unbound universal charstring element.");
        other_value.must_bound("The right operand of concatenation is an unbound universal charstring element.");
        TitanUniversalCharString result = new TitanUniversalCharString();
        if (this.str_val.charstring) {
            if (other_value.str_val.charstring) {
                result.charstring = true;
                result.cstr = new StringBuilder();
                result.cstr.append(this.str_val.cstr.charAt(this.char_pos));
                result.cstr.append(other_value.str_val.cstr.charAt(other_value.char_pos));
            } else {
                result.charstring = false;
                result.val_ptr = new ArrayList<TitanUniversalChar>(2);
                result.val_ptr.add(new TitanUniversalChar('\u0000', '\u0000', '\u0000', this.str_val.cstr.charAt(this.char_pos)));
                result.val_ptr.add(other_value.str_val.val_ptr.get(other_value.char_pos));
            }
        } else {
            result.charstring = false;
            result.val_ptr = new ArrayList<TitanUniversalChar>(2);
            result.val_ptr.add(this.str_val.val_ptr.get(this.char_pos));
            if (other_value.str_val.charstring) {
                result.val_ptr.add(new TitanUniversalChar('\u0000', '\u0000', '\u0000', other_value.str_val.cstr.charAt(other_value.char_pos)));
            } else {
                result.val_ptr.add(other_value.str_val.val_ptr.get(other_value.char_pos));
            }
        }
        return result;
    }

    public TitanUniversalChar get_char() {
        return this.str_val.char_at(this.char_pos);
    }

    public String toString() {
        return this.str_val.toString() + " index: " + this.char_pos;
    }

    public void log() {
        if (this.bound_flag) {
            if (this.str_val.charstring) {
                TTCN_Logger.log_char_escaped(this.str_val.cstr.charAt(this.char_pos));
                return;
            }
            TitanUniversalChar uchar = this.str_val.val_ptr.get(this.char_pos);
            if (TitanUniversalCharString.is_printable(uchar)) {
                TTCN_Logger.log_char('\"');
                TTCN_Logger.log_char_escaped(uchar.getUc_cell());
                TTCN_Logger.log_char('\"');
            } else {
                TTCN_Logger.log_event_str(MessageFormat.format("char({0}, {1}, {2}, {3})", uchar.getUc_group(), uchar.getUc_plane(), uchar.getUc_row(), uchar.getUc_cell()));
            }
        } else {
            TTCN_Logger.log_event_unbound();
        }
    }

    public static boolean operator_equals(TitanUniversalChar ucharValue, TitanUniversalCharString_Element otherValue) {
        otherValue.must_bound("The right operand of comparison is an unbound universal charstring element.");
        return ucharValue.operator_equals(otherValue.get_char());
    }

    public static boolean operator_not_equals(TitanUniversalChar ucharValue, TitanUniversalCharString_Element otherValue) {
        return !TitanUniversalCharString_Element.operator_equals(ucharValue, otherValue);
    }

    public static TitanUniversalCharString operator_concatenate(TitanUniversalChar ucharValue, TitanUniversalCharString_Element other_value) {
        other_value.must_bound("The right operand of concatenation is an unbound universal charstring element.");
        TitanUniversalCharString result = new TitanUniversalCharString();
        if (other_value.str_val.charstring) {
            if (ucharValue.is_char()) {
                result.cstr = new StringBuilder();
                result.cstr.append(ucharValue.getUc_cell());
                result.cstr.append(other_value.str_val.cstr.charAt(other_value.char_pos));
                result.charstring = true;
            } else {
                result.val_ptr = new ArrayList<TitanUniversalChar>(2);
                result.charstring = false;
                result.val_ptr.add(ucharValue);
                result.val_ptr.add(new TitanUniversalChar('\u0000', '\u0000', '\u0000', other_value.str_val.cstr.charAt(other_value.char_pos)));
            }
        } else {
            result.val_ptr = new ArrayList<TitanUniversalChar>(2);
            result.charstring = false;
            result.val_ptr.add(ucharValue);
            result.val_ptr.add(other_value.get_char());
        }
        return result;
    }

    public static boolean operator_equals(String otherValue, TitanUniversalCharString_Element rightValue) {
        rightValue.must_bound("The right operand of comparison is an unbound universal charstring element.");
        if (otherValue == null || otherValue.length() != 1) {
            return false;
        }
        if (rightValue.str_val.charstring) {
            return rightValue.str_val.cstr.charAt(rightValue.char_pos) == otherValue.charAt(0);
        }
        TitanUniversalChar uc = rightValue.str_val.val_ptr.get(rightValue.char_pos);
        return uc.getUc_group() == '\u0000' && uc.getUc_plane() == '\u0000' && uc.getUc_row() == '\u0000' && uc.getUc_cell() == otherValue.charAt(0);
    }

    public static TitanUniversalCharString operator_concatenate(String stringValue, TitanUniversalCharString_Element other_value) {
        other_value.must_bound("The right operand of concatenation is an unbound universal charstring element.");
        if (stringValue == null) {
            return new TitanUniversalCharString(other_value);
        }
        TitanUniversalCharString result = new TitanUniversalCharString();
        if (other_value.str_val.charstring) {
            result.cstr = new StringBuilder();
            result.cstr.append(stringValue);
            result.cstr.append(other_value.str_val.cstr.charAt(other_value.char_pos));
            result.charstring = true;
        } else {
            result.val_ptr = new ArrayList<TitanUniversalChar>();
            result.charstring = false;
            for (int i = 0; i < stringValue.length(); ++i) {
                result.val_ptr.add(new TitanUniversalChar('\u0000', '\u0000', '\u0000', stringValue.charAt(i)));
            }
            result.val_ptr.add(other_value.get_char());
        }
        return result;
    }

    public TitanUniversalCharString rotate_left(int rotate_count) {
        this.must_bound("The left operand of rotate left operator is an unbound universal charstring element.");
        return new TitanUniversalCharString(this);
    }

    public TitanUniversalCharString rotate_left(TitanInteger rotate_count) {
        rotate_count.must_bound("The right operand of rotate left operator is an unbound integer value.");
        return this.rotate_left(rotate_count.get_int());
    }

    public TitanUniversalCharString rotate_right(int rotate_count) {
        this.must_bound("The left operand of rotate right operator is an unbound universal charstring element.");
        return new TitanUniversalCharString(this);
    }

    public TitanUniversalCharString rotate_right(TitanInteger rotate_count) {
        rotate_count.must_bound("The right operand of rotate right operator is an unbound integer value.");
        return this.rotate_right(rotate_count.get_int());
    }
}

