/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.titan.runtime.core.TTCN_Logger;
import org.eclipse.titan.runtime.core.TTCN_Runtime;
import org.eclipse.titan.runtime.core.TitanCharString;
import org.eclipse.titan.runtime.core.TitanLoggerApi;

public class TtcnError
extends Error {
    private String errorMessage;

    public TtcnError(String errorMessage) {
        if (TTCN_Runtime.is_in_ttcn_try_block()) {
            StringBuilder error_str = TTCN_Logger.TTCN_Location.print_location(TTCN_Logger.get_source_info_format() == TTCN_Logger.source_info_format_t.SINFO_STACK, TTCN_Logger.get_source_info_format() != TTCN_Logger.source_info_format_t.SINFO_NONE, TTCN_Logger.get_log_entity_name());
            if (error_str.length() > 0) {
                error_str.append(' ');
            }
            error_str.append("Dynamic test case error: ");
            error_str.append(errorMessage);
            this.errorMessage = error_str.toString();
        } else {
            StringBuilder loc;
            TTCN_Logger.begin_event(TTCN_Logger.Severity.ERROR_UNQUALIFIED);
            if (TTCN_Logger.get_source_info_format() == TTCN_Logger.source_info_format_t.SINFO_NONE && (loc = TTCN_Logger.TTCN_Location.print_location(false, true, TTCN_Logger.log_event_types_t.LOGEVENTTYPES_NO)).length() > 0) {
                TTCN_Logger.log_event_str(loc.toString());
                TTCN_Logger.log_event_str(": ");
            }
            TTCN_Logger.log_event_str("Dynamic test case error: ");
            TTCN_Logger.log_event_str(errorMessage);
            TTCN_Logger.end_event();
            TTCN_Runtime.set_error_verdict();
            TTCN_Logger.log_executor_runtime(TitanLoggerApi.ExecutorRuntime_reason.enum_type.performing__error__recovery);
        }
    }

    public TtcnError(Exception exception) {
        if (TTCN_Runtime.is_in_ttcn_try_block()) {
            StringBuilder error_str = TTCN_Logger.TTCN_Location.print_location(TTCN_Logger.get_source_info_format() == TTCN_Logger.source_info_format_t.SINFO_STACK, TTCN_Logger.get_source_info_format() != TTCN_Logger.source_info_format_t.SINFO_NONE, TTCN_Logger.get_log_entity_name());
            if (error_str.length() > 0) {
                error_str.append(' ');
            }
            StringWriter error = new StringWriter();
            exception.printStackTrace(new PrintWriter(error));
            error_str.append("Dynamic test case error: ");
            error_str.append(error.toString());
            this.errorMessage = error_str.toString();
        } else {
            StringWriter error = new StringWriter();
            exception.printStackTrace(new PrintWriter(error));
            TTCN_Logger.begin_event(TTCN_Logger.Severity.ERROR_UNQUALIFIED);
            TTCN_Logger.log_event_str("Dynamic test case error: ");
            TTCN_Logger.log_event_str(error.toString());
            TTCN_Logger.end_event();
            TTCN_Runtime.set_error_verdict();
            TTCN_Logger.log_executor_runtime(TitanLoggerApi.ExecutorRuntime_reason.enum_type.performing__error__recovery);
        }
    }

    public String get_message() {
        return this.errorMessage;
    }

    public static void TtcnWarning(String warningMessage) {
        TTCN_Logger.begin_event(TTCN_Logger.Severity.WARNING_UNQUALIFIED);
        TTCN_Logger.log_event_str("Warning: ");
        TTCN_Logger.log_event_str(warningMessage);
        TTCN_Logger.end_event();
    }

    public static void TtcnErrorBegin(String errorMessage) {
        if (TTCN_Runtime.is_in_ttcn_try_block()) {
            TTCN_Logger.begin_event_log2str();
            StringBuilder loc = TTCN_Logger.TTCN_Location.print_location(TTCN_Logger.get_source_info_format() == TTCN_Logger.source_info_format_t.SINFO_STACK, TTCN_Logger.get_source_info_format() != TTCN_Logger.source_info_format_t.SINFO_NONE, TTCN_Logger.get_log_entity_name());
            if (loc.length() > 0) {
                TTCN_Logger.log_event_str(loc.toString());
                TTCN_Logger.log_event_str(" ");
            }
            TTCN_Logger.log_event_str("Dynamic test case error: ");
            TTCN_Logger.log_event_str(errorMessage);
        } else {
            TTCN_Logger.begin_event(TTCN_Logger.Severity.ERROR_UNQUALIFIED);
            TTCN_Logger.log_event_str("Dynamic test case error: ");
            TTCN_Logger.log_event_str(errorMessage);
        }
    }

    public static void TtcnErrorEnd() {
        if (TTCN_Runtime.is_in_ttcn_try_block()) {
            TitanCharString error_str = TTCN_Logger.end_event_log2str();
            throw new TtcnError(error_str.get_value().toString());
        }
        TTCN_Logger.end_event();
        TTCN_Runtime.set_error_verdict();
        TTCN_Logger.log_executor_runtime(TitanLoggerApi.ExecutorRuntime_reason.enum_type.performing__error__recovery);
    }

    public static void TtcnWarningBegin(String errorMessage) {
        TTCN_Logger.begin_event(TTCN_Logger.Severity.WARNING_UNQUALIFIED);
        TTCN_Logger.log_event_str("Warning: ");
        TTCN_Logger.log_event_str(errorMessage);
    }

    public static void TtcnWarningEnd() {
        TTCN_Logger.end_event();
    }
}

