/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.error;

import java.io.PrintStream;
import org.eclipse.titanium.error.ErrorHandler;

public class ConsoleErrorHandler
implements ErrorHandler {
    private PrintStream errorStream;
    private PrintStream warningStream;
    private PrintStream informationStream;
    private StringBuilder collectedMessage;

    public ConsoleErrorHandler() {
        this(System.err, System.out, System.out);
    }

    public ConsoleErrorHandler(PrintStream errorStream, PrintStream warningStream, PrintStream informationStream) {
        this.errorStream = errorStream;
        this.warningStream = warningStream;
        this.informationStream = informationStream;
        this.collectedMessage = new StringBuilder();
    }

    @Override
    public void reportException(String context, Exception exception) {
        this.errorStream.println("An exception occured, the stack trace is:\n");
        exception.printStackTrace(this.errorStream);
    }

    @Override
    public void reportErrorMessage(String text) {
        this.errorStream.println(text);
    }

    @Override
    public void reportWarning(String text) {
        this.warningStream.println(text);
    }

    @Override
    public void reportInformation(String text) {
        this.informationStream.println(text);
    }

    @Override
    public void logError(String message) {
        this.collectedMessage.append(message);
    }

    @Override
    public void logException(Exception exception) {
        this.collectedMessage.append("Exception:\n" + exception.getMessage() + "\nStack trace:\n");
        for (StackTraceElement elem : exception.getStackTrace()) {
            this.collectedMessage.append(elem.toString()).append('\n');
        }
    }

    @Override
    public void writeMessageToLog() {
        this.errorStream.println(this.collectedMessage.toString());
        this.collectedMessage.setLength(0);
        this.collectedMessage.trimToSize();
    }
}

