/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.graph.utils;

import edu.uci.ics.jung.graph.DirectedSparseGraph;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;

public class CircleCheck<V, E> {
    private final DirectedSparseGraph<V, E> g;
    private final List<Deque<E>> circles;
    private final Deque<E> circleEdges;
    private final Deque<V> circleVertices;
    private List<V> remaining;

    public CircleCheck(DirectedSparseGraph<V, E> graph) {
        this.g = graph;
        this.circles = new LinkedList<Deque<E>>();
        this.circleEdges = new LinkedList();
        this.circleVertices = new LinkedList<V>();
    }

    public boolean isCyclic() {
        this.remaining = new ArrayList<V>(this.g.getVertices());
        Collections.sort(this.remaining);
        while (!this.remaining.isEmpty()) {
            V v = this.remaining.get(this.remaining.size() - 1);
            this.circleVertices.push(v);
            this.recursiveWalk(v);
            this.circleVertices.pop();
        }
        return !this.circles.isEmpty();
    }

    private void recursiveWalk(V u) {
        ArrayList neighbours = new ArrayList(this.g.getOutEdges(u));
        Collections.sort(neighbours);
        for (Object e : neighbours) {
            Object v = this.g.getDest(e);
            this.circleEdges.push(e);
            if (this.circleVertices.contains(v)) {
                int index = ((LinkedList)this.circleVertices).indexOf(v);
                LinkedList circle = new LinkedList();
                for (int i = index; i >= 0; --i) {
                    circle.push(((LinkedList)this.circleEdges).get(i));
                }
                this.circles.add(circle);
            } else if (this.remaining.contains(v)) {
                this.circleVertices.push(v);
                this.recursiveWalk(v);
                this.circleVertices.pop();
            }
            this.circleEdges.pop();
        }
        this.remaining.remove(u);
    }

    public List<Deque<E>> getCircles() {
        return this.circles;
    }
}

