/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.markers.utils;

import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.titanium.markers.types.CodeSmellType;
import org.eclipse.titanium.markers.types.ProblemType;
import org.eclipse.titanium.markers.types.TaskType;
import org.eclipse.titanium.metrics.MetricData;
import org.eclipse.titanium.metrics.ModuleMetric;
import org.eclipse.titanium.metrics.StatColumn;

public class RiskFactorCalculator {
    private static final ProblemType[] USED_MARKERS = new ProblemType[]{TaskType.FIXME, TaskType.TODO, CodeSmellType.CIRCULAR_IMPORTATION, CodeSmellType.LANGUAGE_MIXING, CodeSmellType.TOO_MANY_STATEMENTS, CodeSmellType.TOO_MANY_PARAMETERS, CodeSmellType.UNCOMMENTED_FUNCTION, CodeSmellType.TYPENAME_IN_DEFINITION, CodeSmellType.MODULENAME_IN_DEFINITION, CodeSmellType.VISIBILITY_IN_DEFINITION, CodeSmellType.UNINITIALIZED_VARIABLE, CodeSmellType.GOTO, CodeSmellType.PRIVATE_COMPONENT_VARIABLE_ACCESS, CodeSmellType.UNUSED_IMPORT, CodeSmellType.UNUSED_GLOBAL_DEFINITION, CodeSmellType.UNUSED_LOCAL_DEFINITION, CodeSmellType.UNUSED_FUNTION_RETURN_VALUES, CodeSmellType.UNUSED_STARTED_FUNCTION_RETURN_VALUES, CodeSmellType.INFINITE_LOOP, CodeSmellType.INVOKING_FUNCTIONS_FROM_SPECIFIC_PLACES, CodeSmellType.NONPRIVATE_PRIVATE, CodeSmellType.SIZECHECK_IN_LOOP, CodeSmellType.TOO_COMPLEX_EXPRESSIONS, CodeSmellType.READONLY_INOUT_PARAM, CodeSmellType.READONLY_OUT_PARAM, CodeSmellType.READONLY_LOC_VARIABLE, CodeSmellType.EMPTY_STATEMENT_BLOCK, CodeSmellType.SETVERDICT_WITHOUT_REASON, CodeSmellType.STOP_IN_FUNCTION, CodeSmellType.UNNECESSARY_VALUEOF, CodeSmellType.MAGIC_NUMBERS, CodeSmellType.MAGIC_STRINGS, CodeSmellType.LOGIC_INVERSION, CodeSmellType.UNNECESSARY_CONTROLS};

    public int measure(IProject project, Map<String, Integer> smellCount) {
        MetricData data = MetricData.measure(project);
        Number n = data.getStatistics(ModuleMetric.LINES_OF_CODE).get(StatColumn.TOTAL);
        int loc = n.intValue();
        int riskFactor = 0;
        for (ProblemType marker : USED_MARKERS) {
            int relativeOccurrene;
            Integer count = smellCount.get(marker.toString());
            if (count == null) {
                throw new IllegalArgumentException("The supplied map has no entry for " + marker.toString() + ". Collate the parameters and the 'usedMarkers' field.");
            }
            if (count == 0) {
                relativeOccurrene = 0;
            } else {
                int actualS = loc / count;
                int baseS = marker.getBaseLine();
                relativeOccurrene = actualS == 0 ? 0 : (actualS > baseS ? 1 : (actualS > baseS / 2 ? 2 : (actualS > baseS / 8 ? 3 : 4)));
            }
            riskFactor += relativeOccurrene * marker.getImpact();
        }
        return riskFactor;
    }

    public ProjectQualityLevel calculate(int riskFactor) {
        int baseRiskFactor = Platform.getPreferencesService().getInt("org.eclipse.titanium", "BASE_RISK_FACTOR", 43, null);
        ProjectQualityLevel quality = riskFactor < baseRiskFactor ? ProjectQualityLevel.VERY_HIGH : (riskFactor < 2 * baseRiskFactor ? ProjectQualityLevel.HIGH : (riskFactor < 3 * baseRiskFactor ? ProjectQualityLevel.MEDIUM : (riskFactor < 4 * baseRiskFactor ? ProjectQualityLevel.LOW : ProjectQualityLevel.VERY_LOW)));
        return quality;
    }

    public static enum ProjectQualityLevel {
        VERY_HIGH("very high"),
        HIGH("high"),
        MEDIUM("medium"),
        LOW("low"),
        VERY_LOW("very low");

        private String name;

        private ProjectQualityLevel(String name) {
            this.name = name;
        }

        public String getHumanReadablename() {
            return this.name;
        }
    }
}

