/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.metrics;

import java.util.EnumSet;
import java.util.Set;
import org.eclipse.titanium.metrics.IMetricEnum;
import org.eclipse.titanium.metrics.StatColumn;

public enum ModuleMetric implements IMetricEnum
{
    NOF_STATEMENTS("Number of statements", "Number of statements in the module"),
    NOF_FUNCTIONS("Number of functions", "Number of functions in the module"),
    NOF_TESTCASES("Number of testcases", "Number of testcases in the module"),
    NOF_ALTSTEPS("Number of altsteps", "Number of altsteps in a module"),
    IN_ENVY("Internal feature envy", "Number of references to entities inside this module"),
    OUT_ENVY("External feature envy", "Number of references to entities outside this module"),
    NOF_FIXME("Fixme comments", "Number of fixme comments"),
    TIMES_IMPORTED("Imported", "The times this module is imported by other modules"),
    NOF_IMPORTS("Imports", "Number of module importations"),
    EFFERENT_COUPLING("Efferent coupling", "Number of referred assignments that are defined outside this module"),
    AFFERENT_COUPLING("Afferent coupling", "Number of assignments in this module that are referred by outside module"),
    INSTABILITY("Instability", "Practically the efferent : (afferent plus efferent) coupling ratio", EnumSet.of(StatColumn.MEAN, StatColumn.DEV), false),
    LINES_OF_CODE("Lines of code", "Number of lines in the altstep body");

    public static final String GROUP_NAME = "Module";
    private String displayName;
    private String hint;
    private Set<StatColumn> requestedStatistics;
    private boolean isInteger;

    private ModuleMetric(String name, String hint) {
        this(name, hint, EnumSet.allOf(StatColumn.class), true);
    }

    private ModuleMetric(String name, String hint, Set<StatColumn> requestedStatistics) {
        this(name, hint, requestedStatistics, true);
    }

    private ModuleMetric(String name, String hint, Set<StatColumn> requestedStatistics, boolean isInteger) {
        this.displayName = name;
        this.hint = hint;
        this.requestedStatistics = requestedStatistics;
        this.isInteger = isInteger;
    }

    @Override
    public String id() {
        return "Module." + this.name();
    }

    @Override
    public String getName() {
        return this.displayName;
    }

    @Override
    public String getHint() {
        return this.hint;
    }

    @Override
    public Set<StatColumn> requestedStatistics() {
        return this.requestedStatistics;
    }

    @Override
    public boolean isInteger() {
        return this.isInteger;
    }

    @Override
    public String groupName() {
        return GROUP_NAME;
    }
}

