/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.movefunction;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Function;
import org.eclipse.titanium.refactoring.movefunction.Destination;
import org.eclipse.titanium.refactoring.movefunction.MoveFunctionMethod;

public class FunctionData
implements Comparable<FunctionData> {
    private final Def_Function definiton;
    private Module module;
    private final String functionBody;
    private boolean toBeMoved;
    private final List<Destination> destinations;
    private List<Module> usedModules;
    private Destination finalDestination;
    private MoveFunctionMethod method;
    private final List<Module> usedBy;

    public FunctionData(Def_Function definiton, String functionBody) {
        this.definiton = definiton;
        this.functionBody = functionBody;
        this.toBeMoved = true;
        this.destinations = new ArrayList<Destination>();
        this.usedModules = new ArrayList<Module>();
        this.usedBy = new ArrayList<Module>();
    }

    public void setToBeMoved(boolean toBeMoved) {
        this.toBeMoved = toBeMoved;
    }

    public void setModule(Module module) {
        this.module = module;
    }

    public void addDestination(Module destination, Integer rating, int newImports) {
        this.destinations.add(new Destination(destination, rating, this, newImports));
    }

    public void addUsedModule(Module module) {
        this.usedModules.add(module);
    }

    public void addUsedModules(List<Module> modules) {
        this.usedModules.addAll(modules);
    }

    public void addUsedBy(Module m) {
        this.usedBy.add(m);
    }

    public void setUsedModules(List<Module> modules) {
        this.usedModules = modules;
    }

    public void setFinalDestination(Destination destination) {
        this.finalDestination = destination;
        if (destination != null) {
            destination.setFunctionData(this);
        }
    }

    public void setRefactoringMethod(MoveFunctionMethod rMethod) {
        this.method = rMethod;
    }

    public Def_Function getDefiniton() {
        return this.definiton;
    }

    public String getFunctionBody() {
        return this.functionBody;
    }

    public boolean isToBeMoved() {
        return this.toBeMoved;
    }

    public List<Destination> getDestinations() {
        return this.destinations;
    }

    public Module getModule() {
        return this.module;
    }

    public List<Module> getUsedModules() {
        return this.usedModules;
    }

    public List<Module> getUsedBy() {
        return this.usedBy;
    }

    public Destination getFinalDestination() {
        return this.finalDestination;
    }

    public MoveFunctionMethod getRefactoringMethod() {
        return this.method;
    }

    @Override
    public int compareTo(FunctionData arg0) {
        return this.getDefiniton().getIdentifier().getDisplayName().compareToIgnoreCase(arg0.getDefiniton().getIdentifier().getDisplayName());
    }

    public void clearDestinations() {
        this.destinations.clear();
    }
}

