/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.runsonscopereduction;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Altstep;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Function;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Testcase;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.TTCN3Module;
import org.eclipse.titan.designer.AST.TTCN3.types.ComponentTypeBody;
import org.eclipse.titan.designer.AST.TTCN3.types.Component_Type;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.titanium.refactoring.runsonscopereduction.ReferenceCheck;
import org.eclipse.titanium.refactoring.runsonscopereduction.RunsOnComponentVisitor;

public class ChangeCreator {
    private final IFile selectedFile;
    private final Definition defSelection;
    private Change change;

    ChangeCreator(IFile selectedFile) {
        this.selectedFile = selectedFile;
        this.defSelection = null;
    }

    ChangeCreator(IFile selectedFile, Definition defSelection) {
        this.selectedFile = selectedFile;
        this.defSelection = defSelection;
    }

    public Change getChange() {
        return this.change;
    }

    public void perform() {
        if (this.selectedFile == null) {
            return;
        }
        this.change = this.createFileChange(this.selectedFile);
    }

    private Change createFileChange(IFile toVisit) {
        if (toVisit == null) {
            return null;
        }
        ProjectSourceParser sourceParser = GlobalParser.getProjectSourceParser((IProject)toVisit.getProject());
        Module module = sourceParser.containedModule(toVisit);
        if (module == null || !(module instanceof TTCN3Module)) {
            return null;
        }
        TextFileChange tfc = new TextFileChange(toVisit.getName(), toVisit);
        TTCN3Module tModule = (TTCN3Module)module;
        try {
            MultiTextEdit resultEdit = this.runsOnScopeEdit(tModule, toVisit);
            if (!resultEdit.hasChildren()) {
                return null;
            }
            tfc.setEdit((TextEdit)resultEdit);
        }
        catch (BadLocationException e) {
            ErrorReporter.logExceptionStackTrace((String)"Error while runs on scope", (Throwable)e);
        }
        catch (CoreException e) {
            ErrorReporter.logError((String)"RunsOnScopeReductionRefactoring/CreateChange.createFileChange(): CoreException while calculating edit locations. ");
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
        return tfc;
    }

    private MultiTextEdit runsOnScopeEdit(TTCN3Module module, IFile toVisit) throws BadLocationException, CoreException {
        MultiTextEdit edit = new MultiTextEdit();
        RunsOnComponentVisitor visit = new RunsOnComponentVisitor();
        if (this.defSelection != null) {
            this.defSelection.accept((ASTVisitor)visit);
        } else {
            module.accept((ASTVisitor)visit);
        }
        Set<Definition> list = visit.getLocations();
        for (Definition node : list) {
            Component_Type componentType;
            Reference runsOnReference;
            Def_Function variable;
            HashSet<Identifier> definitions = new HashSet<Identifier>();
            CompilationTimeStamp timestamp = CompilationTimeStamp.getBaseTimestamp();
            boolean isTestCase = false;
            if (node instanceof Def_Function) {
                variable = (Def_Function)node;
                runsOnReference = variable.getRunsOnReference(timestamp);
                componentType = variable.getRunsOnType(timestamp);
                if (componentType == null) {
                    continue;
                }
            } else if (node instanceof Def_Altstep) {
                variable = (Def_Altstep)node;
                runsOnReference = variable.getRunsOnReference(timestamp);
                componentType = variable.getRunsOnType(timestamp);
                if (componentType == null) {
                    continue;
                }
            } else {
                variable = (Def_Testcase)node;
                runsOnReference = variable.getRunsOnReference(timestamp);
                componentType = variable.getRunsOnType(timestamp);
                if (componentType == null) continue;
                isTestCase = true;
            }
            ReferenceCheck chek = new ReferenceCheck();
            node.accept((ASTVisitor)chek);
            definitions.addAll(chek.getIdentifiers());
            int offset = runsOnReference.getLocation().getOffset();
            int endoffset = runsOnReference.getLocation().getEndOffset();
            if (definitions.isEmpty()) {
                if (isTestCase) continue;
                int currOffset = 0;
                try {
                    InputStream is = toVisit.getContents();
                    InputStreamReader isr = new InputStreamReader(is, toVisit.getCharset());
                    int lenght = offset - node.getIdentifier().getLocation().getEndOffset();
                    char[] content = new char[lenght];
                    isr.skip(offset - lenght);
                    isr.read(content);
                    --lenght;
                    while (content[lenght] != ')') {
                        --lenght;
                        ++currOffset;
                    }
                }
                catch (IOException e) {
                    ErrorReporter.logError((String)"RunsOnScopeReductionRefactoring.ChangeCreator: Error while reading source project.");
                    ErrorReporter.logExceptionStackTrace((Exception)e);
                }
                catch (CoreException ce) {
                    ErrorReporter.logError((String)("ChangeCreator.loadFileContent(): Unable to get file contents (CoreException) for file: " + toVisit.getName()));
                    return null;
                }
                edit.addChild((TextEdit)new DeleteEdit(offset - currOffset, endoffset - offset + currOffset));
                continue;
            }
            if (definitions.contains(runsOnReference.getId())) continue;
            if (definitions.size() == 1) {
                Identifier id = (Identifier)definitions.iterator().next();
                edit.addChild((TextEdit)new ReplaceEdit(offset, endoffset - offset, id.getDisplayName()));
                continue;
            }
            ComponentTypeBody variable2 = ChangeCreator.searchComponent(componentType.getComponentBody(), definitions, new HashSet<Identifier>());
            if (variable2 == null || variable2.getIdentifier() == runsOnReference.getId()) continue;
            edit.addChild((TextEdit)new ReplaceEdit(offset, endoffset - offset, variable2.getIdentifier().getDisplayName()));
        }
        return edit;
    }

    private static ComponentTypeBody searchComponent(ComponentTypeBody component, Set<Identifier> definitions, Set<Identifier> identifiersOfTree) {
        CopyOnWriteArrayList parentComponentBodies = component.getExtensions().getComponentBodies();
        if (parentComponentBodies.isEmpty()) {
            identifiersOfTree.add(component.getIdentifier());
            return null;
        }
        HashSet<Identifier> setNodes = new HashSet<Identifier>();
        setNodes.add(component.getIdentifier());
        for (ComponentTypeBody variable : parentComponentBodies) {
            HashSet<Identifier> identifiersOfNode;
            ComponentTypeBody cb = ChangeCreator.searchComponent(variable, definitions, identifiersOfNode = new HashSet<Identifier>());
            if (cb != null) {
                return cb;
            }
            setNodes.addAll(identifiersOfNode);
        }
        if (setNodes.containsAll(definitions)) {
            identifiersOfTree.addAll(setNodes);
            return component;
        }
        identifiersOfTree.addAll(setNodes);
        return null;
    }
}

