/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.scope.nodes;

import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.TTCN3.statements.Definition_Statement;
import org.eclipse.titanium.refactoring.scope.nodes.StatementNode;

public class MultiDeclaration {
    public final SortedSet<StatementNode> declStmts = new TreeSet<StatementNode>(new MultiDeclarationComparator());

    public int getSize() {
        return this.declStmts.size();
    }

    public StatementNode getFirstStatement() {
        return this.declStmts.first();
    }

    public StatementNode getLastStatement() {
        return this.declStmts.last();
    }

    public boolean isFirstStatement(StatementNode toTest) {
        return this.declStmts.first().equals(toTest);
    }

    public boolean isLastStatement(StatementNode toTest) {
        return this.declStmts.last().equals(toTest);
    }

    public boolean isIntermediateStatement(StatementNode toTest) {
        return !this.isFirstStatement(toTest) && !this.isLastStatement(toTest);
    }

    public boolean isAllStatementsMoved() {
        Iterator it = this.declStmts.iterator();
        while (it.hasNext()) {
            if (((StatementNode)it.next()).isMoved()) continue;
            return false;
        }
        return true;
    }

    public void addDeclarationStatement(StatementNode sn) {
        if (!this.declStmts.add(sn)) {
            ErrorReporter.logError((String)("MultiDeclaration.addDeclarationStatement(): The StatementNode is already present: " + sn));
        }
    }

    private class MultiDeclarationComparator
    implements Comparator<StatementNode> {
        private MultiDeclarationComparator() {
        }

        @Override
        public int compare(StatementNode arg0, StatementNode arg1) {
            int result;
            int o1;
            if (!(arg0.getAstNode() instanceof Definition_Statement) || !(arg1.getAstNode() instanceof Definition_Statement)) {
                ErrorReporter.logError((String)("MultiDeclarationComparator: Invalid StatementNode ASTNode type: " + arg0.getAstNode() + " OR " + arg1.getAstNode()));
            }
            Definition_Statement ds0 = (Definition_Statement)arg0.getAstNode();
            Definition_Statement ds1 = (Definition_Statement)arg1.getAstNode();
            Location loc0 = ds0.getDefinition().getLocation();
            Location loc1 = ds1.getDefinition().getLocation();
            int o0 = loc0.getOffset();
            int n = o0 < (o1 = loc1.getOffset()) ? -1 : (result = o0 == o1 ? 0 : 1);
            if (result == 0 && ds0 != ds1) {
                ErrorReporter.logError((String)("MultiDeclarationComparator: Overlapping Variable declarations at: " + loc0.getOffset() + "-" + loc0.getEndOffset() + " in file: " + loc0.getFile()));
            }
            return result;
        }
    }
}

