/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.parsers;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.titan.common.utils.Assert;
import org.eclipse.titan.log.viewer.parsers.data.TreeModel;
import org.eclipse.titan.log.viewer.preferences.DecipheringPreferenceHandler;

public class Decipherer {
    private Map<String, List<String>> ruleset = null;

    public Decipherer() {
    }

    public Decipherer(String ruleSetName, Map<String, List<String>> ruleSet) {
        Assert.notNull((Object)ruleSetName, (String)"The ruleSetName should not be null.");
        Assert.notNull(ruleSet, (String)"The ruleSet should not be null.");
        this.ruleset = ruleSet;
    }

    public boolean setDecipheringRuleset(String rulesetName) {
        if (rulesetName == null) {
            this.ruleset = null;
            return true;
        }
        this.ruleset = DecipheringPreferenceHandler.getRuleset(rulesetName);
        return this.ruleset != null;
    }

    public String decipher(String msgType, String msg) {
        if (this.ruleset == null && this.findFirstAvailableRuleSet()) {
            return msgType;
        }
        String msgType2 = msgType.trim();
        List<String> rules = this.ruleset.get(msgType2);
        if (rules == null || rules.isEmpty()) {
            if (msgType2.startsWith("@")) {
                rules = this.ruleset.get(msgType2.substring(1));
                if (rules == null || rules.isEmpty()) {
                    return null;
                }
            } else {
                return null;
            }
        }
        TreeModel model = new TreeModel();
        model.inputChanged(msg);
        for (String rule : rules) {
            List<String> splitted = Arrays.asList(rule.split(Pattern.quote(".")));
            String deciphered = model.getFieldValue(splitted);
            if (deciphered == null) continue;
            return deciphered;
        }
        return null;
    }

    private boolean findFirstAvailableRuleSet() {
        List<String> ruleSets = DecipheringPreferenceHandler.getAvailableRuleSets();
        if (ruleSets.isEmpty()) {
            return true;
        }
        this.ruleset = DecipheringPreferenceHandler.getRuleset(ruleSets.get(0));
        return this.ruleset == null;
    }
}

