/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.terminal.connector.telnet.launcher;

import java.text.DateFormat;
import java.util.Date;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsStore;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalConnector;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalConnectorExtension;
import org.eclipse.tm.terminal.connector.telnet.connector.TelnetSettings;
import org.eclipse.tm.terminal.connector.telnet.controls.TelnetWizardConfigurationPanel;
import org.eclipse.tm.terminal.connector.telnet.launcher.TelnetMementoHandler;
import org.eclipse.tm.terminal.connector.telnet.nls.Messages;
import org.eclipse.tm.terminal.view.core.TerminalServiceFactory;
import org.eclipse.tm.terminal.view.core.interfaces.ITerminalService;
import org.eclipse.tm.terminal.view.ui.interfaces.IConfigurationPanel;
import org.eclipse.tm.terminal.view.ui.interfaces.IConfigurationPanelContainer;
import org.eclipse.tm.terminal.view.ui.interfaces.IMementoHandler;
import org.eclipse.tm.terminal.view.ui.internal.SettingsStore;
import org.eclipse.tm.terminal.view.ui.launcher.AbstractLauncherDelegate;

public class TelnetLauncherDelegate
extends AbstractLauncherDelegate {
    private final IMementoHandler mementoHandler = new TelnetMementoHandler();

    public boolean needsUserConfiguration() {
        return true;
    }

    public IConfigurationPanel getPanel(IConfigurationPanelContainer container) {
        return new TelnetWizardConfigurationPanel(container);
    }

    public void execute(Map<String, Object> properties, ITerminalService.Done done) {
        ITerminalService terminal;
        Assert.isNotNull(properties);
        String terminalTitle = this.getTerminalTitle(properties);
        if (terminalTitle != null) {
            properties.put("title", terminalTitle);
        }
        if (!properties.containsKey("terminal.forceNew")) {
            properties.put("terminal.forceNew", Boolean.TRUE);
        }
        if ((terminal = TerminalServiceFactory.getService()) != null) {
            terminal.openConsole(properties, done);
        }
    }

    private String getTerminalTitle(Map<String, Object> properties) {
        String title = this.getDefaultTerminalTitle(properties);
        if (title != null) {
            return title;
        }
        String host = (String)properties.get("ip.host");
        if (host != null) {
            DateFormat format = DateFormat.getDateTimeInstance(3, 3);
            String date = format.format(new Date(System.currentTimeMillis()));
            return NLS.bind((String)Messages.TelnetLauncherDelegate_terminalTitle, (Object[])new String[]{host, date});
        }
        return Messages.TelnetLauncherDelegate_terminalTitle_default;
    }

    public Object getAdapter(Class adapter) {
        if (IMementoHandler.class.equals((Object)adapter)) {
            return this.mementoHandler;
        }
        return super.getAdapter(adapter);
    }

    public ITerminalConnector createTerminalConnector(Map<String, Object> properties) {
        Assert.isNotNull(properties);
        String connectorId = (String)properties.get("tm.terminal.connector.id");
        if (connectorId == null) {
            connectorId = "org.eclipse.tm.terminal.connector.telnet.TelnetConnector";
        }
        String host = (String)properties.get("ip.host");
        Object value = properties.get("ip.port");
        String port = value != null ? value.toString() : null;
        value = properties.get("timeout");
        String timeout = value != null ? value.toString() : null;
        String endOfLine = (String)properties.get("telnet.eol");
        int portOffset = 0;
        if (properties.get("ip.port.offset") instanceof Integer && (portOffset = ((Integer)properties.get("ip.port.offset")).intValue()) < 0) {
            portOffset = 0;
        }
        if (port != null) {
            port = Integer.toString(Integer.decode(port) + portOffset);
        }
        SettingsStore store = new SettingsStore();
        TelnetSettings telnetSettings = new TelnetSettings();
        telnetSettings.setHost(host);
        telnetSettings.setNetworkPort(port);
        if (timeout != null) {
            telnetSettings.setTimeout(timeout);
        }
        telnetSettings.setEndOfLine(endOfLine);
        telnetSettings.save((ISettingsStore)store);
        ITerminalConnector connector = TerminalConnectorExtension.makeTerminalConnector((String)connectorId);
        if (connector != null) {
            connector.setDefaultSettings();
            connector.load((ISettingsStore)store);
        }
        return connector;
    }
}

