/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.menu.legend;

import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.core.ISeriesSettings;
import org.eclipse.swtchart.extensions.core.SeriesListUI;
import org.eclipse.swtchart.extensions.menu.legend.AbstractMenuListener;

public class SetDescriptionAction
extends AbstractMenuListener {
    public SetDescriptionAction(SeriesListUI seriesListUI) {
        super(seriesListUI);
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        menuManager.add((IAction)new Action(){

            public String getText() {
                return "Set Description";
            }

            public String getToolTipText() {
                return "Set a description for the selected series.";
            }

            public void run() {
                BaseChart baseChart = SetDescriptionAction.this.getBaseChart();
                SeriesListUI seriesListUI = SetDescriptionAction.this.getSeriesListUI();
                Table table = seriesListUI.getTable();
                List<ISeries<?>> selectedSeries = SetDescriptionAction.this.getSelectedSeries();
                if (selectedSeries.size() > 0) {
                    String firstDescription = selectedSeries.get(0).getDescription();
                    InputDialog dialog = new InputDialog(table.getShell(), "Description", "Set a description.", firstDescription, new IInputValidator(){

                        public String isValid(String input) {
                            if (input == null) {
                                return "Please set a description.";
                            }
                            if ((input = input.trim()).isEmpty()) {
                                return "The description must be not empty.";
                            }
                            return null;
                        }
                    });
                    if (dialog.open() == 0) {
                        String description = dialog.getValue();
                        for (ISeries<?> series : selectedSeries) {
                            ISeriesSettings seriesSettings = baseChart.getSeriesSettings(series.getId());
                            seriesSettings.setDescription(description);
                            baseChart.applySeriesSettings(series, seriesSettings, true);
                        }
                        SetDescriptionAction.this.refresh();
                    }
                }
            }
        });
    }
}

