/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.GzipEntry;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.IFileSystemObject;

class GzipFileSystemObject
implements IFileSystemObject {
    private GzipEntry fFileSystemObject;
    private String fArchivePath;

    GzipFileSystemObject(GzipEntry fileSystemObject, String archivePath) {
        this.fFileSystemObject = fileSystemObject;
        this.fArchivePath = archivePath;
    }

    @Override
    public String getName() {
        return new Path(this.fFileSystemObject.getName()).lastSegment();
    }

    @Override
    public String getAbsolutePath() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public String getSourceLocation() {
        File file = new File(this.fArchivePath);
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {}
        URI uri = file.toURI();
        Path entryPath = new Path(this.fFileSystemObject.getName());
        URI jarURI = entryPath.isRoot() ? URIUtil.toJarURI((URI)uri, (IPath)Path.EMPTY) : URIUtil.toJarURI((URI)uri, (IPath)entryPath);
        return URIUtil.toUnencodedString((URI)jarURI);
    }

    @Override
    public Object getRawFileSystemObject() {
        return this.fFileSystemObject;
    }

    @Override
    public boolean isDirectory() {
        return this.fFileSystemObject.getFileType() == 53;
    }
}

