/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.profiling.core.instrumented;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.profiling.core.base.ICallStackElement;
import org.eclipse.tracecompass.analysis.profiling.core.callstack2.CallStack;
import org.eclipse.tracecompass.analysis.profiling.core.callstack2.CallStackElement;
import org.eclipse.tracecompass.analysis.profiling.core.callstack2.CallStackHostUtils;
import org.eclipse.tracecompass.analysis.profiling.core.callstack2.CallStackSeries;
import org.eclipse.tracecompass.analysis.profiling.core.tree.IWeightedTreeGroupDescriptor;
import org.eclipse.tracecompass.internal.analysis.profiling.core.instrumented.InstrumentedGroupDescriptor;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;

public class InstrumentedCallStackElement
extends CallStackElement {
    private static final String INSTRUMENTED = "instrumented";
    private static final Pattern IS_INTEGER = Pattern.compile("\\d+");
    private final ITmfStateSystem fStateSystem;
    private final int fQuark;
    private final CallStackHostUtils.IHostIdResolver fHostResolver;
    private final @Nullable CallStackSeries.IThreadIdResolver fThreadIdResolver;
    private @Nullable ITmfStateInterval fSymbolKeyInterval = null;
    private final Map<Integer, ICallStackElement> fNextElements = new HashMap<Integer, ICallStackElement>();
    private @Nullable CallStack fCallstack = null;

    public InstrumentedCallStackElement(CallStackHostUtils.IHostIdResolver hostResolver, ITmfStateSystem stateSystem, Integer quark, IWeightedTreeGroupDescriptor group, @Nullable IWeightedTreeGroupDescriptor nextGroup, @Nullable CallStackSeries.IThreadIdResolver threadIdResolver, @Nullable InstrumentedCallStackElement parent) {
        super(INSTRUMENTED, group, nextGroup, parent);
        this.fStateSystem = stateSystem;
        this.fQuark = quark;
        this.fHostResolver = hostResolver;
        this.fThreadIdResolver = threadIdResolver;
    }

    @Override
    public Collection<ICallStackElement> getChildrenElements() {
        @Nullable IWeightedTreeGroupDescriptor nextGroup = this.getNextGroup();
        if (!(nextGroup instanceof InstrumentedGroupDescriptor)) {
            return Collections.emptyList();
        }
        return this.getNextGroupElements((InstrumentedGroupDescriptor)nextGroup);
    }

    @Override
    public @Nullable InstrumentedCallStackElement getParentElement() {
        return (InstrumentedCallStackElement)super.getParentElement();
    }

    public static Collection<ICallStackElement> getRootElements(InstrumentedGroupDescriptor rootGroup, CallStackHostUtils.IHostIdResolver hostResolver, @Nullable CallStackSeries.IThreadIdResolver resolver, Map<Integer, ICallStackElement> cache) {
        return InstrumentedCallStackElement.getNextElements(rootGroup, rootGroup.getStateSystem(), -1, hostResolver, resolver, null, cache);
    }

    private Collection<ICallStackElement> getNextGroupElements(InstrumentedGroupDescriptor nextGroup) {
        return InstrumentedCallStackElement.getNextElements(nextGroup, this.fStateSystem, this.fQuark, this.fHostResolver, this.fThreadIdResolver, this, this.fNextElements);
    }

    private static Collection<ICallStackElement> getNextElements(InstrumentedGroupDescriptor nextGroup, ITmfStateSystem stateSystem, int baseQuark, CallStackHostUtils.IHostIdResolver hostResolver, @Nullable CallStackSeries.IThreadIdResolver threadIdProvider, @Nullable InstrumentedCallStackElement parent, Map<Integer, ICallStackElement> cache) {
        List quarks = stateSystem.getQuarks(baseQuark, nextGroup.getSubPattern());
        if (quarks.isEmpty()) {
            return Collections.emptyList();
        }
        InstrumentedGroupDescriptor nextLevel = nextGroup.getNextGroup();
        ArrayList<ICallStackElement> elements = new ArrayList<ICallStackElement>(quarks.size());
        for (Integer quark : quarks) {
            ICallStackElement element = cache.get(quark);
            if (element == null) {
                element = new InstrumentedCallStackElement(hostResolver, stateSystem, quark, nextGroup, nextLevel, threadIdProvider, parent);
                if (nextGroup.isSymbolKeyGroup()) {
                    element.setSymbolKeyElement(element);
                }
                if (parent != null) {
                    parent.addChild(element);
                }
                cache.put(quark, element);
            }
            elements.add(element);
        }
        return elements;
    }

    protected @Nullable CallStackSeries.IThreadIdResolver getThreadIdResolver() {
        return this.fThreadIdResolver;
    }

    @Override
    public @NonNull String getName() {
        if (this.fQuark == -1) {
            return "";
        }
        return this.fStateSystem.getAttributeName(this.fQuark);
    }

    @Override
    public int retrieveSymbolKeyAt(long startTime) {
        int processId;
        block8: {
            processId = -1;
            if (this.fQuark != -1) {
                ITmfStateInterval symbolKeyInterval = this.fSymbolKeyInterval;
                if (symbolKeyInterval != null && symbolKeyInterval.intersects(startTime)) {
                    return symbolKeyInterval.getValueInt();
                }
                try {
                    ITmfStateInterval interval;
                    long start = Math.max(this.fStateSystem.getStartTime(), startTime);
                    start = Math.max(start, this.fStateSystem.getCurrentEndTime());
                    this.fSymbolKeyInterval = interval = this.fStateSystem.querySingleState(start, this.fQuark);
                    ITmfStateValue processStateValue = interval.getStateValue();
                    if (processStateValue.getType() == ITmfStateValue.Type.INTEGER) {
                        processId = processStateValue.unboxInt();
                        break block8;
                    }
                    try {
                        String processName = this.fStateSystem.getAttributeName(this.fQuark);
                        if (IS_INTEGER.matcher(processName).matches()) {
                            processId = Integer.parseInt(processName);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                catch (StateSystemDisposedException stateSystemDisposedException) {
                    // empty catch block
                }
            }
        }
        return processId;
    }

    public ITmfStateSystem getStateSystem() {
        return this.fStateSystem;
    }

    public int getQuark() {
        return this.fQuark;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CallStack getCallStack() {
        CallStack callstack = this.fCallstack;
        List<Integer> subAttributes = this.getStackQuarks();
        if (callstack == null) {
            CallStackHostUtils.IHostIdProvider hostProvider = (CallStackHostUtils.IHostIdProvider)this.fHostResolver.apply(this);
            CallStackSeries.IThreadIdResolver threadIdResolver = this.fThreadIdResolver;
            CallStackSeries.IThreadIdProvider threadIdProvider = threadIdResolver == null ? null : threadIdResolver.resolve(hostProvider, this);
            this.fCallstack = callstack = new CallStack(this.getStateSystem(), subAttributes, this, hostProvider, threadIdProvider);
        } else {
            CallStack callStack = callstack;
            synchronized (callStack) {
                if (callstack.getMaxDepth() < subAttributes.size()) {
                    callstack.updateAttributes(subAttributes);
                }
            }
        }
        return Objects.requireNonNull(callstack);
    }

    public List<Integer> getStackQuarks() {
        int stackQuark = this.getStateSystem().optQuarkRelative(this.getQuark(), new String[]{"CallStack"});
        if (stackQuark == -2) {
            return Collections.singletonList(this.getQuark());
        }
        return this.getStateSystem().getSubAttributes(stackQuark, false);
    }

    @Override
    public InstrumentedCallStackElement copyElement() {
        return new InstrumentedCallStackElement(this.fHostResolver, this.fStateSystem, this.fQuark, super.getGroup(), null, this.fThreadIdResolver, null);
    }

    @Override
    public boolean isCallStack() {
        int stackQuark = this.getStateSystem().optQuarkRelative(this.getQuark(), new String[]{"CallStack"});
        return stackQuark != -2;
    }
}

