/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.hover;

import org.eclipse.core.runtime.Adapters;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.hover.ExpressionInformationControlCreator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextSelection;

public class DebugTextHover
implements ITextHover,
ITextHoverExtension,
ITextHoverExtension2 {
    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        IVariable variable = this.getHoverInfo2(textViewer, (IRegion)new Region(offset, 0));
        if (variable == null) {
            return null;
        }
        try {
            IDocument document = textViewer.getDocument();
            int prefix = Math.min(offset, variable.getName().length());
            while (prefix >= 0 && document.getLength() > offset - prefix + variable.getName().length()) {
                if (textViewer.getDocument().get(offset - prefix, variable.getName().length()).equals(variable.getName())) {
                    return new Region(offset - prefix, variable.getName().length());
                }
                --prefix;
            }
        }
        catch (DebugException | BadLocationException ex) {
            DebugUIPlugin.log(ex);
        }
        return null;
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        if (textViewer == null || hoverRegion == null) {
            return null;
        }
        IVariable object = this.getHoverInfo2(textViewer, hoverRegion);
        if (object instanceof IVariable) {
            IVariable var = object;
            return DebugTextHover.getVariableText(var);
        }
        return null;
    }

    private static String getVariableText(IVariable variable) {
        try {
            return DebugTextHover.replaceHTMLChars(variable.getValue().getValueString()) + "<br/>" + DebugTextHover.replaceHTMLChars(variable.getReferenceTypeName());
        }
        catch (DebugException e) {
            DebugUIPlugin.log(e);
            return null;
        }
    }

    private static String replaceHTMLChars(String variableText) {
        StringBuilder buffer = new StringBuilder(variableText.length());
        char[] cArray = variableText.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char character = cArray[n2];
            switch (character) {
                case '<': {
                    buffer.append("&lt;");
                    break;
                }
                case '>': {
                    buffer.append("&gt;");
                    break;
                }
                case '&': {
                    buffer.append("&amp;");
                    break;
                }
                case '\"': {
                    buffer.append("&quot;");
                    break;
                }
                default: {
                    buffer.append(character);
                }
            }
            ++n2;
        }
        return buffer.toString();
    }

    public IInformationControlCreator getHoverControlCreator() {
        return new ExpressionInformationControlCreator();
    }

    public IVariable getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        if (textViewer == null || hoverRegion == null) {
            return null;
        }
        TextSelection sel = new TextSelection(textViewer.getDocument(), hoverRegion.getOffset(), hoverRegion.getLength());
        return (IVariable)Adapters.adapt((Object)sel, IVariable.class);
    }
}

