/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.variables;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IIndexedValue;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.views.variables.IndexedValuePartition;

public class IndexedVariablePartition
extends PlatformObject
implements IVariable {
    private final int fOffset;
    private final int fLength;
    private final IDebugElement fOriginalVariable;
    private final IIndexedValue fOriginalValue;
    private final IIndexedValue fValuePartition;
    private String fName = null;

    public IndexedVariablePartition(IDebugElement variable, IIndexedValue value, int offset, int length) {
        this.fOriginalVariable = variable;
        this.fOriginalValue = value;
        this.fOffset = offset;
        this.fLength = length;
        this.fValuePartition = new IndexedValuePartition(value, offset, length);
    }

    public IValue getValue() {
        return this.fValuePartition;
    }

    public String getName() {
        if (this.fName == null) {
            StringBuilder buf = new StringBuilder();
            buf.append("[");
            buf.append(this.fOffset);
            buf.append("...");
            buf.append(this.fOffset + this.fLength - 1);
            buf.append("]");
            this.fName = buf.toString();
        }
        return this.fName;
    }

    public String getReferenceTypeName() throws DebugException {
        if (this.fOriginalVariable instanceof IVariable) {
            IVariable variable = (IVariable)this.fOriginalVariable;
            return variable.getReferenceTypeName();
        }
        return "";
    }

    public boolean hasValueChanged() {
        return false;
    }

    public String getModelIdentifier() {
        return this.fOriginalValue.getModelIdentifier();
    }

    public IDebugTarget getDebugTarget() {
        return this.fOriginalValue.getDebugTarget();
    }

    public ILaunch getLaunch() {
        return this.fOriginalValue.getLaunch();
    }

    public void setValue(String expression) throws DebugException {
        throw new DebugException((IStatus)new Status(4, "org.eclipse.debug.ui", 120, "Value modification not supported for indexed partitions.", null));
    }

    public void setValue(IValue value) throws DebugException {
        throw new DebugException((IStatus)new Status(4, "org.eclipse.debug.ui", 120, "Value modification not supported for indexed partitions.", null));
    }

    public boolean supportsValueModification() {
        return false;
    }

    public boolean verifyValue(String expression) {
        return false;
    }

    public boolean verifyValue(IValue value) {
        return false;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IndexedVariablePartition) {
            IndexedVariablePartition partition = (IndexedVariablePartition)((Object)obj);
            return this.fOriginalVariable.equals(partition.fOriginalVariable) && this.fOffset == partition.fOffset && this.fLength == partition.fLength;
        }
        return false;
    }

    public int hashCode() {
        return this.fOriginalVariable.hashCode() + this.fOffset;
    }
}

