/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.tmf.ui.multiview.ui.view;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.nebula.widgets.opal.duallist.DLItem;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.incubator.internal.tmf.ui.multiview.ui.view.DualSelectionList;
import org.eclipse.tracecompass.incubator.internal.tmf.ui.multiview.ui.view.Messages;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderManager;
import org.eclipse.tracecompass.tmf.core.dataprovider.IDataProviderDescriptor;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class SetProviderDialog
extends Dialog {
    private static final IDataProviderDescriptor.ProviderType[] TYPES = new IDataProviderDescriptor.ProviderType[2];
    private final ITmfTrace fTrace;
    private DualSelectionList fSelector;
    private List<IDataProviderDescriptor> fDescriptors = new ArrayList<IDataProviderDescriptor>();

    static {
        SetProviderDialog.TYPES[0] = IDataProviderDescriptor.ProviderType.TREE_TIME_XY;
        SetProviderDialog.TYPES[1] = IDataProviderDescriptor.ProviderType.TIME_GRAPH;
    }

    public SetProviderDialog(Shell parentShell, ITmfTrace trace, List<IDataProviderDescriptor> currentDescriptors) {
        super(parentShell);
        this.fTrace = trace;
        this.fDescriptors.addAll(currentDescriptors);
    }

    public List<IDataProviderDescriptor> getDescriptors() {
        return this.fDescriptors;
    }

    protected Control createDialogArea(Composite p) {
        p.getShell().setText(Messages.Dialog_SetDataProviderName);
        Composite parent = (Composite)super.createDialogArea(p);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 12;
        parent.setLayout((Layout)layout);
        this.fSelector = new DualSelectionList(parent, 2048);
        this.fSelector.setLayoutData(new GridData(4, 16384, true, true, 2, 1));
        this.fSelector.addSelectionChangeListener(e -> this.checkOK());
        this.populateProvidersList();
        return parent;
    }

    protected Control createButtonBar(Composite parent) {
        Control c = super.createButtonBar(parent);
        this.checkOK();
        return c;
    }

    protected void okPressed() {
        this.checkOK();
        super.okPressed();
    }

    private void checkOK() {
        this.fDescriptors.clear();
        this.fDescriptors.addAll(this.fSelector.getSelected().stream().map(e -> (IDataProviderDescriptor)e.getData()).collect(Collectors.toList()));
        Button okButton = this.getButton(0);
        if (okButton == null) {
            return;
        }
        okButton.setEnabled(this.fDescriptors.size() > 0);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }

    private void populateProvidersList() {
        List descriptors = DataProviderManager.getInstance().getAvailableProviders(this.fTrace);
        this.fSelector.setItems(SetProviderDialog.descriptors2DLItems(descriptors));
        this.fSelector.setSelected(SetProviderDialog.descriptors2DLItems(this.fDescriptors));
    }

    private static List<DLItem> descriptors2DLItems(List<IDataProviderDescriptor> descriptors) {
        return descriptors.stream().filter(elem -> Arrays.asList(TYPES).contains(elem.getType())).map(e -> SetProviderDialog.descriptor2DLItem(e)).collect(Collectors.toList());
    }

    private static DLItem descriptor2DLItem(IDataProviderDescriptor e) {
        DLItem ret = new DLItem(String.format("%s (%s)", e.getName(), e.getType().name()));
        ret.setData((Object)e);
        return ret;
    }
}

