/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.messages;

import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.ros2.core.Activator;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.messages.Ros2MessagesAnalysis;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.objects.Ros2ObjectsUtil;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messages.Ros2CallbackPublicationInstance;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messages.Ros2MessageTransportInstance;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2ClientObject;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2NodeObject;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2ObjectHandle;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2PublisherObject;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2ServiceObject;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2SubscriptionObject;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2TimerObject;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;

public class Ros2MessagesUtil {
    public static final @NonNull String LIST_NODES = "Nodes";
    public static final @NonNull String LIST_PUBLISHERS = "Publishers";
    public static final @NonNull String LIST_SUBSCRIPTIONS = "Subscriptions";
    public static final @NonNull String LIST_CLIENTS = "Clients";
    public static final @NonNull String LIST_SERVICES = "Services";
    public static final @NonNull String LIST_TIMERS = "Timers";
    public static final @NonNull String LIST_TRANSPORT = "Transport";
    public static final @NonNull String LIST_CALLBACK_PUBLICATION = "Callback-publication";
    private static final @NonNull String SS_WILDCARD = "*";
    private static final @NonNull String SS_HANDLE_PAIR_SEP = "+";

    private Ros2MessagesUtil() {
    }

    private static void assertStateSystem(ITmfStateSystem ss) {
        if (!ss.getSSID().equals(Ros2MessagesAnalysis.getFullAnalysisId())) {
            throw new IllegalArgumentException(String.format("wrong state system; need '%s', got '%s'", Ros2MessagesAnalysis.getFullAnalysisId(), ss.getSSID()));
        }
    }

    public static String[] getNodeAttribute(@NonNull Ros2NodeObject nodeObject) {
        return new String[]{nodeObject.getTraceName(), LIST_NODES, nodeObject.getStringId()};
    }

    private static String[] getPublisherRelativeAttribute(@NonNull Ros2ObjectHandle publisherHandle) {
        return new String[]{LIST_PUBLISHERS, publisherHandle.getStringId()};
    }

    private static String[] getSubscriptionRelativeAttribute(@NonNull Ros2ObjectHandle subscriptionHandle) {
        return new String[]{LIST_SUBSCRIPTIONS, subscriptionHandle.getStringId()};
    }

    private static String[] getClientRelativeAttribute(@NonNull Ros2ObjectHandle clientHandle, @NonNull ClientServiceInstanceType type) {
        return new String[]{LIST_CLIENTS, clientHandle.getStringId(), type.toString()};
    }

    private static String[] getServiceRelativeAttribute(@NonNull Ros2ObjectHandle serviceHandle, @NonNull ClientServiceInstanceType type) {
        return new String[]{LIST_SERVICES, serviceHandle.getStringId(), type.toString()};
    }

    private static String[] getTimerRelativeAttribute(@NonNull Ros2ObjectHandle timerHandle) {
        return new String[]{LIST_TIMERS, timerHandle.getStringId()};
    }

    private static String[] getTransportInstanceAttribute(@NonNull Ros2ObjectHandle publisherHandle, @NonNull Ros2ObjectHandle subscriptionHandle) {
        return new String[]{LIST_TRANSPORT, publisherHandle.getStringId() + SS_HANDLE_PAIR_SEP + subscriptionHandle.getStringId()};
    }

    private static String[] getCallbackPublicationInstanceAttribute(@NonNull Ros2ObjectHandle callbackOwnerHandle, @NonNull Ros2ObjectHandle publisherHandle) {
        return new String[]{LIST_CALLBACK_PUBLICATION, callbackOwnerHandle.getStringId() + SS_HANDLE_PAIR_SEP + publisherHandle.getStringId()};
    }

    public static Integer getNodeQuark(ITmfStateSystem ss, @NonNull Ros2NodeObject nodeObject) {
        Ros2MessagesUtil.assertStateSystem(ss);
        try {
            return ss.getQuarkAbsolute(Ros2MessagesUtil.getNodeAttribute(nodeObject));
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            return null;
        }
    }

    public static Integer getNodeQuark(ITmfStateSystem ss, ITmfStateSystem objectsSs, long timestamp, @NonNull Ros2ObjectHandle nodeHandle) {
        Ros2NodeObject nodeObject = Ros2ObjectsUtil.getNodeObjectFromHandle(objectsSs, timestamp, nodeHandle);
        if (nodeObject == null) {
            Activator.getInstance().logError("could not find corresponding node object");
            return null;
        }
        return Ros2MessagesUtil.getNodeQuark(ss, nodeObject);
    }

    public static int getNodeQuarkAndAdd(ITmfStateSystemBuilder ss, @NonNull Ros2NodeObject nodeObject) {
        Ros2MessagesUtil.assertStateSystem((ITmfStateSystem)ss);
        return ss.getQuarkAbsoluteAndAdd(Ros2MessagesUtil.getNodeAttribute(nodeObject));
    }

    public static @Nullable Integer getPublisherQuarkAndAdd(ITmfStateSystemBuilder ss, ITmfStateSystem objectsSs, long timestamp, @NonNull Ros2ObjectHandle publisherHandle) {
        Ros2PublisherObject pubObject = Ros2ObjectsUtil.getPublisherObjectFromHandle(objectsSs, timestamp, publisherHandle);
        if (pubObject == null) {
            Activator.getInstance().logError("could not find corresponding publisher object for publisherHandle=" + publisherHandle.toString());
            return null;
        }
        Integer nodeQuark = Ros2MessagesUtil.getNodeQuark((ITmfStateSystem)ss, objectsSs, timestamp, pubObject.getNodeHandle());
        if (nodeQuark == null) {
            return null;
        }
        return ss.getQuarkRelativeAndAdd(nodeQuark.intValue(), Ros2MessagesUtil.getPublisherRelativeAttribute(publisherHandle));
    }

    public static @Nullable Integer getSubscriptionQuarkAndAdd(ITmfStateSystemBuilder ss, ITmfStateSystem objectsSs, long timestamp, @NonNull Ros2ObjectHandle subscriptionHandle) {
        Ros2SubscriptionObject subscriptionObject = Ros2ObjectsUtil.getSubscriptionObjectFromHandle(objectsSs, timestamp, subscriptionHandle);
        if (subscriptionObject == null) {
            Activator.getInstance().logError("could not find corresponding subscription object for subscriptionHandle=" + subscriptionHandle.toString());
            return null;
        }
        Integer nodeQuark = Ros2MessagesUtil.getNodeQuark((ITmfStateSystem)ss, objectsSs, timestamp, subscriptionObject.getNodeHandle());
        if (nodeQuark == null) {
            return null;
        }
        return ss.getQuarkRelativeAndAdd(nodeQuark.intValue(), Ros2MessagesUtil.getSubscriptionRelativeAttribute(subscriptionHandle));
    }

    public static @Nullable Integer getClientQuarkAndAdd(ITmfStateSystemBuilder ss, ITmfStateSystem objectsSs, long timestamp, @NonNull Ros2ObjectHandle clientHandle, @NonNull ClientServiceInstanceType type) {
        Ros2ClientObject clientObject = Ros2ObjectsUtil.getClientObjectFromHandle(objectsSs, timestamp, clientHandle);
        if (clientObject == null) {
            Activator.getInstance().logError("could not find corresponding client object for clientHandle=" + clientHandle.toString());
            return null;
        }
        Integer nodeQuark = Ros2MessagesUtil.getNodeQuark((ITmfStateSystem)ss, objectsSs, timestamp, clientObject.getNodeHandle());
        if (nodeQuark == null) {
            return null;
        }
        return ss.getQuarkRelativeAndAdd(nodeQuark.intValue(), Ros2MessagesUtil.getClientRelativeAttribute(clientHandle, type));
    }

    public static @Nullable Integer getServiceQuarkAndAdd(ITmfStateSystemBuilder ss, ITmfStateSystem objectsSs, long timestamp, @NonNull Ros2ObjectHandle serviceHandle, @NonNull ClientServiceInstanceType type) {
        Ros2ServiceObject serviceObject = Ros2ObjectsUtil.getServiceObjectFromHandle(objectsSs, timestamp, serviceHandle);
        if (serviceObject == null) {
            Activator.getInstance().logError("could not find corresponding client object for serviceHandle=" + serviceHandle.toString());
            return null;
        }
        Integer nodeQuark = Ros2MessagesUtil.getNodeQuark((ITmfStateSystem)ss, objectsSs, timestamp, serviceObject.getNodeHandle());
        if (nodeQuark == null) {
            return null;
        }
        return ss.getQuarkRelativeAndAdd(nodeQuark.intValue(), Ros2MessagesUtil.getServiceRelativeAttribute(serviceHandle, type));
    }

    public static @Nullable Integer getTimerQuarkAndAdd(ITmfStateSystemBuilder ss, ITmfStateSystem objectsSs, long timestamp, @NonNull Ros2ObjectHandle timerHandle) {
        Ros2TimerObject timerObject = Ros2ObjectsUtil.getTimerObjectFromHandle(objectsSs, timestamp, timerHandle);
        if (timerObject == null) {
            Activator.getInstance().logError("could not find corresponding timer object for timerHandle=" + timerHandle.toString());
            return null;
        }
        Integer nodeQuark = Ros2MessagesUtil.getNodeQuark((ITmfStateSystem)ss, objectsSs, timestamp, timerObject.getNodeHandle());
        if (nodeQuark == null) {
            return null;
        }
        return ss.getQuarkRelativeAndAdd(nodeQuark.intValue(), Ros2MessagesUtil.getTimerRelativeAttribute(timerHandle));
    }

    public static int getTransportInstanceQuarkAndAdd(ITmfStateSystemBuilder ss, @NonNull Ros2ObjectHandle publisherHandle, @NonNull Ros2ObjectHandle subscriptionHandle) {
        Ros2MessagesUtil.assertStateSystem((ITmfStateSystem)ss);
        return ss.getQuarkAbsoluteAndAdd(Ros2MessagesUtil.getTransportInstanceAttribute(publisherHandle, subscriptionHandle));
    }

    public static int getCallbackPublicationInstanceQuarkAndAdd(ITmfStateSystemBuilder ss, @NonNull Ros2ObjectHandle callbackOwnerHandle, @NonNull Ros2ObjectHandle publisherHandle) {
        Ros2MessagesUtil.assertStateSystem((ITmfStateSystem)ss);
        return ss.getQuarkAbsoluteAndAdd(Ros2MessagesUtil.getCallbackPublicationInstanceAttribute(callbackOwnerHandle, publisherHandle));
    }

    public static @Nullable Integer getPublisherQuark(ITmfStateSystem ss, ITmfStateSystem objectsSs, long timestamp, @NonNull Ros2ObjectHandle publisherHandle) {
        Ros2PublisherObject pubObject = Ros2ObjectsUtil.getPublisherObjectFromHandle(objectsSs, timestamp, publisherHandle);
        if (pubObject == null) {
            Activator.getInstance().logError("could not find corresponding publisher object for publisherHandle=" + publisherHandle.toString());
            return null;
        }
        Integer nodeQuark = Ros2MessagesUtil.getNodeQuark(ss, objectsSs, timestamp, pubObject.getNodeHandle());
        if (nodeQuark == null) {
            return null;
        }
        try {
            return ss.getQuarkRelative(nodeQuark.intValue(), Ros2MessagesUtil.getPublisherRelativeAttribute(publisherHandle));
        }
        catch (IndexOutOfBoundsException | AttributeNotFoundException throwable) {
            return null;
        }
    }

    public static @Nullable Integer getSubscriptionQuark(ITmfStateSystem ss, ITmfStateSystem objectsSs, long timestamp, @NonNull Ros2ObjectHandle subscriptionHandle) {
        Ros2SubscriptionObject subscriptionObject = Ros2ObjectsUtil.getSubscriptionObjectFromHandle(objectsSs, timestamp, subscriptionHandle);
        if (subscriptionObject == null) {
            Activator.getInstance().logError("could not find corresponding subscription object for subscriptionHandle=" + subscriptionHandle.toString());
            return null;
        }
        Integer nodeQuark = Ros2MessagesUtil.getNodeQuark(ss, objectsSs, timestamp, subscriptionObject.getNodeHandle());
        if (nodeQuark == null) {
            return null;
        }
        try {
            return ss.getQuarkRelative(nodeQuark.intValue(), Ros2MessagesUtil.getSubscriptionRelativeAttribute(subscriptionHandle));
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            return null;
        }
    }

    public static @Nullable Integer getClientQuark(ITmfStateSystem ss, ITmfStateSystem objectsSs, long timestamp, @NonNull Ros2ObjectHandle clientHandle, @NonNull ClientServiceInstanceType type) {
        Ros2ClientObject clientObject = Ros2ObjectsUtil.getClientObjectFromHandle(objectsSs, timestamp, clientHandle);
        if (clientObject == null) {
            Activator.getInstance().logError("could not find corresponding client object for clientHandle=" + clientHandle.toString());
            return null;
        }
        Integer nodeQuark = Ros2MessagesUtil.getNodeQuark(ss, objectsSs, timestamp, clientObject.getNodeHandle());
        if (nodeQuark == null) {
            return null;
        }
        try {
            return ss.getQuarkRelative(nodeQuark.intValue(), Ros2MessagesUtil.getClientRelativeAttribute(clientHandle, type));
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            return null;
        }
    }

    public static @Nullable Integer getServiceQuark(ITmfStateSystem ss, ITmfStateSystem objectsSs, long timestamp, @NonNull Ros2ObjectHandle serviceHandle, @NonNull ClientServiceInstanceType type) {
        Ros2ServiceObject serviceObject = Ros2ObjectsUtil.getServiceObjectFromHandle(objectsSs, timestamp, serviceHandle);
        if (serviceObject == null) {
            Activator.getInstance().logError("could not find corresponding service object for serviceHandle=" + serviceHandle.toString());
            return null;
        }
        Integer nodeQuark = Ros2MessagesUtil.getNodeQuark(ss, objectsSs, timestamp, serviceObject.getNodeHandle());
        if (nodeQuark == null) {
            return null;
        }
        try {
            return ss.getQuarkRelative(nodeQuark.intValue(), Ros2MessagesUtil.getServiceRelativeAttribute(serviceHandle, type));
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            return null;
        }
    }

    public static @Nullable Integer getTimerQuark(ITmfStateSystem ss, ITmfStateSystem objectsSs, long timestamp, @NonNull Ros2ObjectHandle timerHandle) {
        Ros2TimerObject timerObject = Ros2ObjectsUtil.getTimerObjectFromHandle(objectsSs, timestamp, timerHandle);
        if (timerObject == null) {
            Activator.getInstance().logError("could not find corresponding timer object for timerHandle=" + timerHandle.toString());
            return null;
        }
        Integer nodeQuark = Ros2MessagesUtil.getNodeQuark(ss, objectsSs, timestamp, timerObject.getNodeHandle());
        if (nodeQuark == null) {
            return null;
        }
        try {
            return ss.getQuarkRelative(nodeQuark.intValue(), Ros2MessagesUtil.getTimerRelativeAttribute(timerHandle));
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            return null;
        }
    }

    public static @Nullable Integer getTransportInstanceQuark(ITmfStateSystem ss, @NonNull Ros2ObjectHandle publisherHandle, @NonNull Ros2ObjectHandle subscriptionHandle) {
        Ros2MessagesUtil.assertStateSystem(ss);
        try {
            return ss.getQuarkAbsolute(Ros2MessagesUtil.getTransportInstanceAttribute(publisherHandle, subscriptionHandle));
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            return null;
        }
    }

    private static @NonNull Collection<@NonNull Integer> getTransportInstanceQuarks(ITmfStateSystem ss) {
        Ros2MessagesUtil.assertStateSystem(ss);
        try {
            int transportInstanceListQuark = ss.getQuarkAbsolute(new String[]{LIST_TRANSPORT});
            return ss.getQuarks(transportInstanceListQuark, new String[]{SS_WILDCARD, SS_WILDCARD});
        }
        catch (AttributeNotFoundException e) {
            return Collections.emptyList();
        }
    }

    public static @Nullable Integer getCallbackPublicationInstanceQuark(ITmfStateSystem ss, @NonNull Ros2ObjectHandle callbackOwnerHandle, @NonNull Ros2ObjectHandle publisherHandle) {
        Ros2MessagesUtil.assertStateSystem(ss);
        try {
            return ss.getQuarkAbsolute(Ros2MessagesUtil.getCallbackPublicationInstanceAttribute(callbackOwnerHandle, publisherHandle));
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            return null;
        }
    }

    private static @NonNull Collection<@NonNull Integer> getCallbackPublicationInstanceQuarks(ITmfStateSystem ss) {
        Ros2MessagesUtil.assertStateSystem(ss);
        try {
            int callbackPublicationInstanceListQuark = ss.getQuarkAbsolute(new String[]{LIST_CALLBACK_PUBLICATION});
            return ss.getSubAttributes(callbackPublicationInstanceListQuark, false);
        }
        catch (AttributeNotFoundException e) {
            return Collections.emptyList();
        }
    }

    public static @Nullable ITmfStateInterval getPubInstanceInterval(ITmfStateSystem ss, ITmfStateSystem objectsSs, long timestamp, @NonNull Ros2ObjectHandle publisherHandle) {
        Integer pubQuark = Ros2MessagesUtil.getPublisherQuark(ss, objectsSs, timestamp, publisherHandle);
        if (pubQuark == null) {
            return null;
        }
        try {
            ITmfStateInterval pubInstanceInterval = ss.querySingleState(timestamp, pubQuark.intValue());
            if (pubInstanceInterval.getValue() != null) {
                return pubInstanceInterval;
            }
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {
            // empty catch block
        }
        Activator.getInstance().logError("pub instance not found");
        return null;
    }

    public static @Nullable ITmfStateInterval getNextPubInstanceInterval(ITmfStateSystem ss, ITmfStateSystem objectsSs, long timestamp, @NonNull Ros2ObjectHandle publisherHandle) {
        Integer pubQuark = Ros2MessagesUtil.getPublisherQuark(ss, objectsSs, timestamp, publisherHandle);
        if (pubQuark == null) {
            return null;
        }
        try {
            ITmfStateInterval pubInstanceInterval = ss.querySingleState(timestamp, pubQuark.intValue());
            if (pubInstanceInterval.getValue() != null) {
                return pubInstanceInterval;
            }
            if (pubInstanceInterval.getEndTime() < ss.getCurrentEndTime() && (pubInstanceInterval = ss.querySingleState(pubInstanceInterval.getEndTime() + 1L, pubQuark.intValue())).getValue() != null) {
                return pubInstanceInterval;
            }
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {
            // empty catch block
        }
        Activator.getInstance().logError("next pub instance not found");
        return null;
    }

    public static Collection<@NonNull ITmfStateInterval> getPubInstanceIntervalsBetween(ITmfStateSystem ss, ITmfStateSystem objectsSs, long startTime, long endTime, @NonNull Ros2ObjectHandle publisherHandle) {
        Integer pubQuark = Ros2MessagesUtil.getPublisherQuark(ss, objectsSs, startTime, publisherHandle);
        if (pubQuark == null) {
            return Collections.emptyList();
        }
        ArrayList<@NonNull ITmfStateInterval> intervals = new ArrayList<ITmfStateInterval>();
        try {
            for (ITmfStateInterval interval : ss.query2D(Collections.singleton(pubQuark), startTime, endTime)) {
                if (interval.getValue() == null) continue;
                intervals.add(interval);
            }
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {
            // empty catch block
        }
        if (intervals.isEmpty()) {
            Activator.getInstance().logError("no pub instances found between interval");
        }
        return intervals;
    }

    public static @Nullable ITmfStateInterval getSubCallbackInstanceInterval(ITmfStateSystem ss, ITmfStateSystem objectsSs, long timestamp, @NonNull Ros2ObjectHandle subscriptionHandle) {
        Integer subQuark = Ros2MessagesUtil.getSubscriptionQuark(ss, objectsSs, timestamp, subscriptionHandle);
        if (subQuark == null) {
            return null;
        }
        try {
            ITmfStateInterval subCallbackInstanceInterval = ss.querySingleState(timestamp, subQuark.intValue());
            if (subCallbackInstanceInterval.getValue() != null) {
                return subCallbackInstanceInterval;
            }
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {
            // empty catch block
        }
        Activator.getInstance().logError("sub callback instance not found");
        return null;
    }

    public static @Nullable ITmfStateInterval getNextSubCallbackInstanceInterval(ITmfStateSystem ss, ITmfStateSystem objectsSs, long timestamp, @NonNull Ros2ObjectHandle subscriptionHandle) {
        Integer subQuark = Ros2MessagesUtil.getSubscriptionQuark(ss, objectsSs, timestamp, subscriptionHandle);
        if (subQuark == null) {
            return null;
        }
        try {
            ITmfStateInterval subCallbackInstanceInterval = ss.querySingleState(timestamp, subQuark.intValue());
            if (subCallbackInstanceInterval.getValue() != null) {
                return subCallbackInstanceInterval;
            }
            if (subCallbackInstanceInterval.getEndTime() < ss.getCurrentEndTime() && (subCallbackInstanceInterval = ss.querySingleState(subCallbackInstanceInterval.getEndTime() + 1L, subQuark.intValue())).getValue() != null) {
                return subCallbackInstanceInterval;
            }
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {
            // empty catch block
        }
        Activator.getInstance().logError("next sub callback instance not found");
        return null;
    }

    public static @Nullable ITmfStateInterval getPreviousSubCallbackInstanceInterval(ITmfStateSystem ss, ITmfStateSystem objectsSs, long timestamp, @NonNull Ros2ObjectHandle subscriptionHandle) {
        Integer subQuark = Ros2MessagesUtil.getSubscriptionQuark(ss, objectsSs, timestamp, subscriptionHandle);
        if (subQuark == null) {
            return null;
        }
        try {
            ITmfStateInterval subCallbackInstanceInterval = ss.querySingleState(timestamp, subQuark.intValue());
            if (subCallbackInstanceInterval.getValue() != null) {
                return subCallbackInstanceInterval;
            }
            if (subCallbackInstanceInterval.getStartTime() > ss.getStartTime() && (subCallbackInstanceInterval = ss.querySingleState(subCallbackInstanceInterval.getStartTime() - 1L, subQuark.intValue())).getValue() != null) {
                return subCallbackInstanceInterval;
            }
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {
            // empty catch block
        }
        Activator.getInstance().logError("previous sub callback instance not found");
        return null;
    }

    public static @Nullable ITmfStateInterval getTimerCallbackInstanceInterval(ITmfStateSystem ss, ITmfStateSystem objectsSs, long timestamp, @NonNull Ros2ObjectHandle timerHandle) {
        Integer timerQuark = Ros2MessagesUtil.getTimerQuark(ss, objectsSs, timestamp, timerHandle);
        if (timerQuark == null) {
            return null;
        }
        try {
            ITmfStateInterval timerCallbackInstanceInterval = ss.querySingleState(timestamp, timerQuark.intValue());
            if (timerCallbackInstanceInterval.getValue() != null) {
                return timerCallbackInstanceInterval;
            }
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {
            // empty catch block
        }
        Activator.getInstance().logError("timer callback instance not found");
        return null;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static @NonNull Stream<@NonNull Ros2MessageTransportInstance> getTransportInstances(ITmfStateSystem ss, @NonNull Collection<@NonNull Integer> transportInstanceQuarks, long startTime, long endTime) {
        try {
            @NonNull Iterable intervalsIterable = ss.query2D(transportInstanceQuarks, startTime, endTime);
            return Streams.stream((Iterable)intervalsIterable).filter(interval -> interval.getValue() != null).map(interval -> (Ros2MessageTransportInstance)((Object)((Object)Objects.requireNonNull(interval.getValue()))));
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {
            Activator.getInstance().logError("transport instances not found");
            return Objects.requireNonNull(Stream.empty());
        }
    }

    public static @NonNull Stream<@NonNull Ros2MessageTransportInstance> getTransportInstances(ITmfStateSystem ss, long startTime, long endTime) {
        Collection<@NonNull Integer> transportInstanceQuarks = Ros2MessagesUtil.getTransportInstanceQuarks(ss);
        return Ros2MessagesUtil.getTransportInstances(ss, transportInstanceQuarks, startTime, endTime);
    }

    public static @NonNull Stream<@NonNull Ros2MessageTransportInstance> getOutgoingTransportLinks(ITmfStateSystem ss, long sourcePublicationTimestamp, @NonNull Ros2ObjectHandle sourcePublisherHandle) {
        Collection<@NonNull Integer> transportInstanceQuarks = Ros2MessagesUtil.getTransportInstanceQuarks(ss);
        return Ros2MessagesUtil.getTransportInstances(ss, transportInstanceQuarks, sourcePublicationTimestamp, sourcePublicationTimestamp + 1L).filter(transportInstance -> transportInstance.getSourceTimestamp() == sourcePublicationTimestamp && transportInstance.getPublisherHandle().equals((Object)sourcePublisherHandle));
    }

    public static @NonNull Stream<@NonNull Ros2MessageTransportInstance> getIncomingTransportLinks(ITmfStateSystem ss, long destinationTakeTimestamp, @NonNull Ros2ObjectHandle destinationSubscriptionHandle) {
        Collection<@NonNull Integer> transportInstanceQuarks = Ros2MessagesUtil.getTransportInstanceQuarks(ss);
        return Ros2MessagesUtil.getTransportInstances(ss, transportInstanceQuarks, destinationTakeTimestamp - 1L, destinationTakeTimestamp).filter(transportInstance -> transportInstance.getDestinationTimestamp() == destinationTakeTimestamp && transportInstance.getSubscriptionHandle().equals((Object)destinationSubscriptionHandle));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static @NonNull Stream<@NonNull Ros2CallbackPublicationInstance> getCallbackPublicationInstances(ITmfStateSystem ss, @NonNull Collection<@NonNull Integer> callbackPublicationInstanceQuarks, long startTime, long endTime) {
        try {
            @NonNull Iterable intervalsIterable = ss.query2D(callbackPublicationInstanceQuarks, startTime, endTime);
            return Streams.stream((Iterable)intervalsIterable).filter(interval -> interval.getValue() != null).map(interval -> (Ros2CallbackPublicationInstance)((Object)((Object)Objects.requireNonNull(interval.getValue()))));
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {
            Activator.getInstance().logError("callback-publication instances not found");
            return Objects.requireNonNull(Stream.empty());
        }
    }

    public static @NonNull Stream<@NonNull Ros2CallbackPublicationInstance> getCallbackPublicationInstances(ITmfStateSystem ss, long startTime, long endTime) {
        Collection<@NonNull Integer> callbackPublicationInstanceQuarks = Ros2MessagesUtil.getCallbackPublicationInstanceQuarks(ss);
        return Ros2MessagesUtil.getCallbackPublicationInstances(ss, callbackPublicationInstanceQuarks, startTime, endTime);
    }

    public static @NonNull Stream<@NonNull Ros2CallbackPublicationInstance> getOutgoingCallbackPublicationLinks(ITmfStateSystem ss, @NonNull Ros2ObjectHandle callbackOwnerHandle, long startTime, long endTime) {
        Collection<@NonNull Integer> callbackPublicationInstanceQuarks = Ros2MessagesUtil.getCallbackPublicationInstanceQuarks(ss);
        return Ros2MessagesUtil.getCallbackPublicationInstances(ss, callbackPublicationInstanceQuarks, startTime, endTime).filter(callbackPublicationInstance -> callbackPublicationInstance.getCallbackOwnerHandle().equals((Object)callbackOwnerHandle));
    }

    public static @NonNull Stream<@NonNull Ros2CallbackPublicationInstance> getIncomingCallbackPublicationLinks(ITmfStateSystem ss, @NonNull Ros2ObjectHandle publisherHandle, long publicationTimestamp) {
        Collection<@NonNull Integer> callbackPublicationInstanceQuarks = Ros2MessagesUtil.getCallbackPublicationInstanceQuarks(ss);
        return Ros2MessagesUtil.getCallbackPublicationInstances(ss, callbackPublicationInstanceQuarks, publicationTimestamp, publicationTimestamp + 1L).filter(callbackPublicationInstance -> callbackPublicationInstance.getPublisherHandle().equals((Object)publisherHandle) && callbackPublicationInstance.getPublicationTimestamp() == publicationTimestamp);
    }

    public static enum ClientServiceInstanceType {
        SEND,
        TAKE;

    }
}

