/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros2.core.model;

import com.google.common.base.Objects;
import java.util.Comparator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.datastore.core.serialization.ISafeByteBufferReader;
import org.eclipse.tracecompass.datastore.core.serialization.ISafeByteBufferWriter;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.Ros2SerializationUtil;

public class HostInfo
implements Comparable<HostInfo> {
    private static Comparator<HostInfo> COMPARATOR = Comparator.comparing(HostInfo::getHostname);
    private final @NonNull String fHostId;
    private final @NonNull String fHostname;
    private final int fSerializedValueSize;

    public HostInfo(@NonNull String hostId, @NonNull String hostname) {
        this.fHostId = hostId;
        this.fHostname = hostname;
        int size = 0;
        size += Ros2SerializationUtil.getStringSerializedSize(this.fHostId);
        this.fSerializedValueSize = size += Ros2SerializationUtil.getStringSerializedSize(this.fHostname);
    }

    public @NonNull String getId() {
        return this.fHostId;
    }

    public @NonNull String getHostname() {
        return this.fHostname;
    }

    @Override
    public int compareTo(HostInfo o) {
        return COMPARATOR.compare(this, o);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.fHostId});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HostInfo o = (HostInfo)obj;
        return o.fHostId.equals(this.fHostId);
    }

    public @NonNull String toString() {
        return String.format("HostInfo: hostId=%s, hostname=%s", this.fHostId, this.fHostname);
    }

    public void serializeValue(@NonNull ISafeByteBufferWriter buffer) {
        buffer.putString(this.fHostId);
        buffer.putString(this.fHostname);
    }

    public int getSerializedValueSize() {
        return this.fSerializedValueSize;
    }

    public static final @NonNull HostInfo read(ISafeByteBufferReader buffer) {
        String hostId = buffer.getString();
        String hostname = buffer.getString();
        return new HostInfo(hostId, hostname);
    }
}

