/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.events;

import java.util.Set;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.events.AbstractHandledEventProcessor;
import org.eclipse.swtchart.extensions.events.IHandledEventProcessor;

public class MouseMoveShiftEvent
extends AbstractHandledEventProcessor
implements IHandledEventProcessor {
    private int shiftMask = SWT.MOD2;

    @Override
    public int getEvent() {
        return 4;
    }

    @Override
    public int getStateMask() {
        return SWT.MOD1;
    }

    @Override
    public void handleEvent(BaseChart baseChart, Event event) {
        if ((event.stateMask & this.shiftMask) == this.shiftMask) {
            boolean supportDataShift = baseChart.getChartSettings().isSupportDataShift();
            Set<String> selectedSeriesIds = baseChart.getSelectedSeriesIds();
            if (supportDataShift && selectedSeriesIds.size() > 0) {
                if (baseChart.getMoveStartTime() == 0L) {
                    baseChart.setCursor(baseChart.getDisplay().getSystemCursor(8));
                    baseChart.setMoveStartTime(System.currentTimeMillis());
                    baseChart.setXMoveStart(event.x);
                    baseChart.setYMoveStart(event.y);
                } else {
                    long deltaTime = System.currentTimeMillis() - baseChart.getMoveStartTime();
                    if (deltaTime <= 350L) {
                        baseChart.setMoveStartTime(System.currentTimeMillis());
                        double shiftX = baseChart.getShiftValue(baseChart.getXMoveStart(), event.x, "X_AXIS");
                        double shiftY = baseChart.getShiftValue(baseChart.getYMoveStart(), event.y, "Y_AXIS");
                        for (String selectedSeriesId : selectedSeriesIds) {
                            ISeries dataSeries = baseChart.getSeriesSet().getSeries(selectedSeriesId);
                            if (dataSeries == null) continue;
                            baseChart.shiftSeries(selectedSeriesId, shiftX, shiftY);
                        }
                        baseChart.redraw();
                        baseChart.setXMoveStart(event.x);
                        baseChart.setYMoveStart(event.y);
                    } else {
                        baseChart.setMoveStartTime(0L);
                        baseChart.setXMoveStart(0);
                        baseChart.setYMoveStart(0);
                    }
                }
            }
        }
    }
}

