/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.fieldcount.core;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multiset;
import java.lang.reflect.Type;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiGenericAspect;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiTableEntryAspect;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiAnalysis;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiResultTable;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiTableClass;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiTableEntry;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiData;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiLongNumber;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiTimeRange;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiTimestamp;
import org.eclipse.tracecompass.internal.tmf.core.filter.TmfFilterHelper;
import org.eclipse.tracecompass.tmf.core.TmfCommonConstants;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfBaseAspects;
import org.eclipse.tracecompass.tmf.core.filter.ITmfFilter;
import org.eclipse.tracecompass.tmf.core.request.ITmfEventRequest;
import org.eclipse.tracecompass.tmf.core.request.TmfEventRequest;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;

public class FieldCountAnalysis
extends LamiAnalysis {
    private static final long MASK = 1023L;
    private static final int MEMORY_SANITY_LIMIT = 40000;

    public FieldCountAnalysis() {
        super("Event Fields Count", false, trace -> true, Collections.emptyList());
    }

    protected synchronized void initialize() {
    }

    public boolean canExecute(ITmfTrace trace) {
        return true;
    }

    private static int workRemaining(ITmfTrace trace) {
        return (int)Math.min(trace.getNbEvents() / 1024L, Integer.MAX_VALUE);
    }

    public List<LamiResultTable> execute(final ITmfTrace trace, @Nullable TmfTimeRange timeRange, String extraParamsString, final IProgressMonitor monitor) throws CoreException {
        ArrayList<LamiResultTable> results = new ArrayList<LamiResultTable>();
        final ArrayList aspects = new ArrayList();
        TmfTimeRange tr = timeRange == null ? TmfTimeRange.ETERNITY : timeRange;
        Set forbidden = TmfBaseAspects.getBaseAspects().stream().map(ITmfEventAspect::getName).collect(Collectors.toSet());
        Iterable<ITmfEventAspect<?>> eventAspects = FieldCountAnalysis.getTraceAspects(trace);
        for (ITmfEventAspect<?> aspect : eventAspects) {
            Type type;
            Type[] genericInterfaces = aspect.getClass().getGenericInterfaces();
            if (genericInterfaces.length <= 0 || (type = genericInterfaces[0]).getClass().isAssignableFrom(Number.class) || forbidden.contains(aspect.getName())) continue;
            aspects.add(aspect);
        }
        ITmfFilter filter = TmfFilterHelper.buildFilterFromRegex(Collections.singleton(extraParamsString), (ITmfTrace)trace);
        final Predicate<ITmfEvent> filterPred = event -> filter == null || filter.matches(event);
        final SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)"Event Count Analysis", (int)FieldCountAnalysis.workRemaining(trace));
        final AtomicLong done = new AtomicLong();
        final HashMap eventAspectCounts = new HashMap();
        TmfEventRequest req = new TmfEventRequest(ITmfEvent.class, tr, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.BACKGROUND){

            public void handleData(ITmfEvent event) {
                if (monitor.isCanceled()) {
                    this.cancel();
                }
                if (filterPred.test(event)) {
                    for (ITmfEventAspect aspect : aspects) {
                        Multiset dataSet;
                        Object resolved = aspect.resolve(event);
                        if (resolved == null || (dataSet = eventAspectCounts.computeIfAbsent(aspect.getName(), unused -> HashMultiset.create())).size() >= 40000 && !dataSet.contains(resolved)) continue;
                        dataSet.add((Object)String.valueOf(resolved));
                    }
                }
                if ((done.incrementAndGet() & 0x3FFL) == 0L) {
                    mon.setWorkRemaining(FieldCountAnalysis.workRemaining(trace));
                    mon.worked(1);
                    monitor.setTaskName("Event Count Analysis (" + NumberFormat.getInstance().format(done.get()) + " events read)");
                }
            }
        };
        trace.sendRequest((ITmfEventRequest)req);
        try {
            req.waitForCompletion();
            for (Map.Entry entry : eventAspectCounts.entrySet()) {
                Multiset dataSet = (Multiset)entry.getValue();
                ArrayList<LamiTableEntry> entries = new ArrayList<LamiTableEntry>();
                for (String element : dataSet.elementSet()) {
                    List<LamiData> data = Arrays.asList(new LamiData[]{new LamiString(element), new LamiLongNumber(Long.valueOf(dataSet.count((Object)element)))});
                    entries.add(new LamiTableEntry(data));
                }
                List<LamiTableEntryAspect> tableAspects = Arrays.asList(new LamiTableEntryAspect[]{new LamiCategoryAspect((String)entry.getKey(), 0), new LamiCountAspect("count", 1)});
                LamiTableClass tableClass = new LamiTableClass((String)entry.getKey(), (String)entry.getKey(), tableAspects, Collections.emptySet());
                LamiResultTable lrt = new LamiResultTable(FieldCountAnalysis.createTimeRange(tr), tableClass, entries);
                results.add(lrt);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return results;
    }

    private static Iterable<ITmfEventAspect<?>> getTraceAspects(ITmfTrace trace) {
        if (trace instanceof TmfExperiment) {
            return FieldCountAnalysis.getExperimentAspects((TmfExperiment)trace);
        }
        return trace.getEventAspects();
    }

    private static Iterable<ITmfEventAspect<?>> getExperimentAspects(TmfExperiment experiment) {
        List traces = experiment.getTraces();
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        builder.add((Object)TmfBaseAspects.getTraceNameAspect());
        String commonTraceType = FieldCountAnalysis.getCommonTraceType(experiment);
        if (commonTraceType != null) {
            builder.addAll(((ITmfTrace)traces.get(0)).getEventAspects());
        } else {
            for (ITmfTrace trace : traces) {
                Iterable traceAspects = trace.getEventAspects();
                builder.addAll(traceAspects);
            }
        }
        return builder.build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static @Nullable String getCommonTraceType(TmfExperiment experiment) {
        String commonTraceType = null;
        try {
            Iterator iterator = experiment.getTraces().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return commonTraceType;
                }
                ITmfTrace trace = (ITmfTrace)iterator.next();
                IResource resource = trace.getResource();
                if (resource == null) {
                    return null;
                }
                String traceType = resource.getPersistentProperty(TmfCommonConstants.TRACETYPE);
                if (commonTraceType != null && !commonTraceType.equals(traceType)) {
                    return null;
                }
                commonTraceType = traceType;
            }
        }
        catch (CoreException e) {
            return null;
        }
    }

    private static LamiTimeRange createTimeRange(TmfTimeRange timeRange) {
        return new LamiTimeRange(new LamiTimestamp(timeRange.getStartTime().toNanos()), new LamiTimestamp(timeRange.getStartTime().toNanos()));
    }

    private final class LamiCategoryAspect
    extends LamiGenericAspect {
        private LamiCategoryAspect(String name, int column) {
            super(name, null, column, false, false);
        }
    }

    private final class LamiCountAspect
    extends LamiGenericAspect {
        private LamiCountAspect(String name, int column) {
            super(name, null, column, true, false);
        }
    }

    private final class LamiString
    extends LamiData {
        private final String fElement;

        private LamiString(String element) {
            this.fElement = element;
        }

        public @NonNull String toString() {
            return this.fElement;
        }
    }
}

