/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.repository;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URL;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.repository.AuthenticationFailedException;
import org.eclipse.equinox.internal.p2.repository.Messages;
import org.eclipse.equinox.internal.p2.repository.Transport;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.IProvisioningEventBus;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.ProvisioningListener;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.SynchronousProvisioningListener;
import org.eclipse.equinox.internal.provisional.p2.repository.IStateful;
import org.eclipse.equinox.internal.provisional.p2.repository.RepositoryEvent;
import org.eclipse.equinox.p2.core.IAgentLocation;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.osgi.util.NLS;

public class CacheManager {
    public static final String SERVICE_NAME = CacheManager.class.getName();
    private final IAgentLocation agentLocation;
    private final Transport transport;
    private static SynchronousProvisioningListener busListener;
    private static final String DOWNLOADING = "downloading";
    private static final String JAR_EXTENSION = ".jar";
    private static final String XML_EXTENSION = ".xml";
    private final HashSet<String> knownPrefixes = new HashSet(5);

    public CacheManager(IAgentLocation agentLocation, Transport transport) {
        this.agentLocation = agentLocation;
        this.transport = transport;
    }

    private int computeHash(URI repositoryLocation) {
        return repositoryLocation.hashCode();
    }

    public File createCacheFromFile(URI remoteFile, IProgressMonitor monitor) throws ProvisionException, IOException {
        if (!CacheManager.isURL(remoteFile)) {
            throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.repository", 1000, NLS.bind((String)Messages.CacheManager_CannotLoadNonUrlLocation, (Object)remoteFile), null));
        }
        SubMonitor submonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1000);
        try {
            File cacheFile = this.getCacheFile(remoteFile);
            boolean stale = true;
            long lastModified = cacheFile.lastModified();
            long lastModifiedRemote = 0L;
            try {
                lastModifiedRemote = this.transport.getLastModified(remoteFile, (IProgressMonitor)submonitor.newChild(1));
                if (lastModifiedRemote <= 0L) {
                    LogHelper.log((IStatus)new Status(2, "org.eclipse.equinox.p2.repository", "Server returned lastModified <= 0 for " + String.valueOf(remoteFile)));
                }
            }
            catch (AuthenticationFailedException e) {
                throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.repository", 1007, NLS.bind((String)Messages.CacheManager_AuthenticationFaileFor_0, (Object)remoteFile), null));
            }
            catch (FileNotFoundException e) {
                throw new FileNotFoundException(NLS.bind((String)Messages.CacheManager_Repository_not_found, (Object)remoteFile));
            }
            catch (CoreException e) {
                Throwable ex;
                IStatus status = e.getStatus();
                if (status == null) {
                    throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.repository", 1000, NLS.bind((String)Messages.CacheManager_FailedCommunicationWithRepo_0, (Object)remoteFile), (Throwable)e));
                }
                if (status.getException() instanceof FileNotFoundException) {
                    throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.repository", 1000, status.getMessage(), status.getException()));
                }
                if (status.getException() != null && (ex = status.getException()).getClass() == SocketTimeoutException.class) {
                    throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.repository", 1002, NLS.bind((String)Messages.CacheManager_FailedCommunicationWithRepo_0, (Object)remoteFile), ex));
                }
                throw new ProvisionException(status);
            }
            boolean bl = stale = lastModifiedRemote != lastModified;
            if (!stale) {
                File file = cacheFile;
                return file;
            }
            this.updateCache(cacheFile, remoteFile, lastModifiedRemote, submonitor);
            File file = cacheFile;
            return file;
        }
        finally {
            submonitor.done();
        }
    }

    public File createCache(URI repositoryLocation, String prefix, IProgressMonitor monitor) throws IOException, ProvisionException {
        if (!CacheManager.isURL(repositoryLocation)) {
            throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.repository", 1000, NLS.bind((String)Messages.CacheManager_CannotLoadNonUrlLocation, (Object)repositoryLocation), null));
        }
        SubMonitor submonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1000);
        try {
            this.knownPrefixes.add(prefix);
            File cacheFile = this.getCache(repositoryLocation, prefix);
            URI jarLocation = URIUtil.append((URI)repositoryLocation, (String)(prefix + JAR_EXTENSION));
            URI xmlLocation = URIUtil.append((URI)repositoryLocation, (String)(prefix + XML_EXTENSION));
            int hashCode = this.computeHash(repositoryLocation);
            boolean stale = true;
            long lastModified = 0L;
            String name = null;
            String useExtension = JAR_EXTENSION;
            URI remoteFile = jarLocation;
            if (cacheFile != null) {
                lastModified = cacheFile.lastModified();
                name = cacheFile.getName();
            }
            long lastModifiedRemote = 0L;
            boolean useJar = true;
            try {
                lastModifiedRemote = this.getLastModified(jarLocation, (IProgressMonitor)submonitor.newChild(1));
                if (lastModifiedRemote <= 0L) {
                    LogHelper.log((IStatus)new Status(2, "org.eclipse.equinox.p2.repository", "Server returned lastModified <= 0 for " + String.valueOf(jarLocation)));
                }
            }
            catch (AuthenticationFailedException e) {
                throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.repository", 1007, NLS.bind((String)Messages.CacheManager_AuthenticationFaileFor_0, (Object)repositoryLocation), null));
            }
            catch (CoreException e) {
                Throwable ex;
                useJar = false;
                if (e.getStatus() != null && e.getStatus().getException() != null && (ex = e.getStatus().getException()).getClass() == SocketTimeoutException.class) {
                    throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.repository", 1002, NLS.bind((String)Messages.CacheManager_FailedCommunicationWithRepo_0, (Object)repositoryLocation), ex));
                }
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                useJar = false;
            }
            if (submonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (useJar) {
                stale = lastModifiedRemote != lastModified || name != null && name.endsWith(XML_EXTENSION) || lastModifiedRemote <= 0L;
            } else {
                try {
                    lastModifiedRemote = this.getLastModified(xmlLocation, (IProgressMonitor)submonitor.newChild(1));
                    if (lastModifiedRemote <= 0L) {
                        LogHelper.log((IStatus)new Status(2, "org.eclipse.equinox.p2.repository", "Server returned lastModified <= 0 for " + String.valueOf(xmlLocation)));
                    }
                }
                catch (FileNotFoundException e) {
                    throw new FileNotFoundException(NLS.bind((String)Messages.CacheManager_Neither_0_nor_1_found, (Object)jarLocation, (Object)xmlLocation));
                }
                catch (AuthenticationFailedException e) {
                    throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.repository", 1007, NLS.bind((String)Messages.CacheManager_AuthenticationFaileFor_0, (Object)repositoryLocation), null));
                }
                catch (CoreException e) {
                    IStatus status = e.getStatus();
                    if (status == null) {
                        throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.repository", 1000, NLS.bind((String)Messages.CacheManager_FailedCommunicationWithRepo_0, (Object)repositoryLocation), (Throwable)e));
                    }
                    if (status.getException() instanceof FileNotFoundException) {
                        throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.repository", 1000, status.getMessage(), status.getException()));
                    }
                    throw new ProvisionException(status);
                }
                stale = lastModifiedRemote != lastModified || name != null && name.endsWith(JAR_EXTENSION) || lastModifiedRemote <= 0L;
                useExtension = XML_EXTENSION;
                remoteFile = xmlLocation;
            }
            if (!stale) {
                File file = cacheFile;
                return file;
            }
            cacheFile = new File(this.getCacheDirectory(), prefix + hashCode + useExtension);
            this.updateCache(cacheFile, remoteFile, lastModifiedRemote, submonitor);
            File file = cacheFile;
            return file;
        }
        finally {
            submonitor.done();
        }
    }

    private long getLastModified(URI location, IProgressMonitor monitor) throws AuthenticationFailedException, FileNotFoundException, CoreException {
        CoreException exception = null;
        long lastModifiedRemote = -1L;
        do {
            try {
                lastModifiedRemote = this.transport.getLastModified(location, monitor);
            }
            catch (CoreException e) {
                if (e.getStatus() == null) {
                    throw e;
                }
                exception = e;
            }
        } while (exception != null && exception.getStatus() != null && exception.getStatus().getCode() == 13);
        if (exception != null) {
            throw exception;
        }
        return lastModifiedRemote;
    }

    void deleteCache(URI repositoryLocation) {
        for (String prefix : this.knownPrefixes) {
            File[] cacheFiles;
            File[] fileArray = cacheFiles = this.getCacheFiles(repositoryLocation, prefix);
            int n = cacheFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File cacheFile = fileArray[n2];
                this.safeDelete(cacheFile);
                this.safeDelete(new File(new File(cacheFile.getParentFile(), DOWNLOADING), cacheFile.getName()));
                ++n2;
            }
        }
    }

    protected File getCache(URI repositoryLocation, String prefix) {
        File[] files = this.getCacheFiles(repositoryLocation, prefix);
        if (files[0].exists()) {
            return files[0];
        }
        return files[1].exists() ? files[1] : null;
    }

    protected File getCacheDirectory() {
        return URIUtil.toFile((URI)this.agentLocation.getDataArea("org.eclipse.equinox.p2.repository/cache/"));
    }

    private File[] getCacheFiles(URI repositoryLocation, String prefix) {
        File[] files = new File[2];
        File dataAreaFile = this.getCacheDirectory();
        int hashCode = this.computeHash(repositoryLocation);
        files[0] = new File(dataAreaFile, prefix + hashCode + JAR_EXTENSION);
        files[1] = new File(dataAreaFile, prefix + hashCode + XML_EXTENSION);
        return files;
    }

    private File getCacheFile(URI url) {
        File dataAreaFile = this.getCacheDirectory();
        int hashCode = this.computeHash(url);
        return new File(dataAreaFile, Integer.toString(hashCode));
    }

    private static boolean isURL(URI location) {
        try {
            new URL(location.toASCIIString());
        }
        catch (MalformedURLException e) {
            return false;
        }
        return true;
    }

    private void registerRepoEventListener(IProvisioningEventBus eventBus) {
        if (busListener == null) {
            busListener = o -> {
                RepositoryEvent event;
                if (o instanceof RepositoryEvent && 1 == (event = (RepositoryEvent)o).getKind() && event.getRepositoryType() == 0) {
                    this.deleteCache(event.getRepositoryLocation());
                }
            };
        }
        eventBus.addListener((ProvisioningListener)busListener);
    }

    private boolean safeDelete(File file) {
        if (file.exists() && !file.delete()) {
            file.deleteOnExit();
            return true;
        }
        return false;
    }

    public void setEventBus(IProvisioningEventBus newBus) {
        this.registerRepoEventListener(newBus);
    }

    public void unsetEventBus(IProvisioningEventBus oldBus) {
        this.unregisterRepoEventListener(oldBus);
    }

    private void unregisterRepoEventListener(IProvisioningEventBus bus) {
        if (bus != null && busListener != null) {
            bus.removeListener((ProvisioningListener)busListener);
        }
    }

    protected void updateCache(File cacheFile, URI remoteFile, long lastModifiedRemote, SubMonitor submonitor) throws FileNotFoundException, IOException, ProvisionException {
        IStatus result;
        File tempFile;
        block18: {
            cacheFile.getParentFile().mkdirs();
            File downloadDir = new File(cacheFile.getParentFile(), DOWNLOADING);
            if (!downloadDir.exists()) {
                downloadDir.mkdir();
            }
            if ((tempFile = new File(downloadDir, cacheFile.getName())).exists()) {
                this.safeDelete(tempFile);
            }
            tempFile.createNewFile();
            StatefulStream stream = null;
            try {
                stream = new StatefulStream(new FileOutputStream(tempFile));
            }
            catch (Exception e) {
                throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.repository", e.getMessage(), (Throwable)e));
            }
            result = null;
            try {
                try {
                    submonitor.setWorkRemaining(1000);
                    result = this.transport.download(remoteFile, stream, (IProgressMonitor)submonitor.newChild(1000));
                    while (result.getCode() == 13) {
                        result = this.transport.download(remoteFile, stream, (IProgressMonitor)submonitor.newChild(1000));
                    }
                }
                catch (OperationCanceledException e) {
                    result = stream.getStatus();
                    stream.close();
                    if (result == null || !result.isOK()) {
                        this.safeDelete(tempFile);
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                stream.close();
                if (result == null || !result.isOK()) {
                    this.safeDelete(tempFile);
                }
                throw throwable;
            }
            stream.close();
            if (result == null || !result.isOK()) {
                this.safeDelete(tempFile);
            }
        }
        if (result.isOK()) {
            if (cacheFile.exists()) {
                this.safeDelete(cacheFile);
            }
            if (tempFile.renameTo(cacheFile)) {
                if (lastModifiedRemote != -1L && lastModifiedRemote != 0L) {
                    cacheFile.setLastModified(lastModifiedRemote);
                }
                return;
            }
            result = new Status(4, "org.eclipse.equinox.p2.repository", NLS.bind((String)Messages.CacheManage_ErrorRenamingCache, (Object[])new Object[]{remoteFile.toString(), tempFile.getAbsolutePath(), cacheFile.getAbsolutePath()}));
        }
        if (result.getSeverity() == 8 || submonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        throw new ProvisionException(result);
    }

    private static class StatefulStream
    extends BufferedOutputStream
    implements IStateful {
        private IStatus status;

        public StatefulStream(OutputStream stream) {
            super(stream);
        }

        @Override
        public IStatus getStatus() {
            return this.status;
        }

        @Override
        public void setStatus(IStatus aStatus) {
            this.status = aStatus;
        }
    }
}

