/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.hyperlink;

import java.util.ResourceBundle;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class OpenHyperlinkAction
extends TextEditorAction {
    private IHyperlinkDetector[] fHyperlinkDetectors;
    private ITextViewer fTextViewer;

    public OpenHyperlinkAction(ResourceBundle bundle, String prefix, ITextEditor editor, ITextViewer viewer) {
        super(bundle, prefix, editor);
        this.fTextViewer = viewer;
    }

    public void setHyperlinkDetectors(IHyperlinkDetector[] detectors) {
        this.fHyperlinkDetectors = detectors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.fHyperlinkDetectors == null) {
            return;
        }
        ISelection selection = this.getTextEditor().getSelectionProvider().getSelection();
        if (selection == null || !(selection instanceof ITextSelection)) {
            return;
        }
        ITextSelection textSelection = (ITextSelection)selection;
        Region region = new Region(textSelection.getOffset(), textSelection.getLength());
        IHyperlink hyperlink = null;
        IHyperlinkDetector[] iHyperlinkDetectorArray = this.fHyperlinkDetectors;
        synchronized (this.fHyperlinkDetectors) {
            int i = 0;
            int length = this.fHyperlinkDetectors.length;
            while (i < length && hyperlink == null) {
                final IHyperlinkDetector detector = this.fHyperlinkDetectors[i];
                if (detector != null) {
                    final IHyperlink[][] hyperlinks = new IHyperlink[1][];
                    SafeRunnable detectorRunnable = new SafeRunnable((IRegion)region){
                        private final /* synthetic */ IRegion val$region;
                        {
                            this.val$region = iRegion;
                        }

                        public void run() throws Exception {
                            hyperlinks[0] = detector.detectHyperlinks(OpenHyperlinkAction.this.fTextViewer, this.val$region, false);
                        }
                    };
                    SafeRunner.run((ISafeRunnable)detectorRunnable);
                    if (hyperlinks[0] != null && hyperlinks.length > 0) {
                        hyperlink = hyperlinks[0][0];
                    }
                }
                ++i;
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            if (hyperlink != null) {
                this.getTextEditor().setHighlightRange(Math.max(0, region.getOffset() - 1), 0, false);
                hyperlink.open();
            }
            return;
        }
    }
}

