/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.dialogs;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.ease.modules.ScriptParameter;
import org.eclipse.ease.ui.help.hovers.MethodHelp;
import org.eclipse.ease.ui.help.hovers.ModuleHelp;
import org.eclipse.ease.ui.modules.ui.ModulesTools;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ParametersDialog
extends TitleAreaDialog {
    private final Method fMethod;
    private final Parameter[] fParameters;
    private final List<String> fUserInput = new ArrayList<String>();

    public ParametersDialog(Shell shell, Method method, Parameter[] parameters) {
        super(shell);
        this.fMethod = method;
        this.fParameters = parameters;
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(String.format("Call %s()", this.fMethod.getName()));
        this.setMessage(String.format("Provide parameters for the method call. Strings will be transformed to the correct parameter format if possible. Use '%s' for null values.", "<null>"));
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(1808));
        int index = 0;
        while (index < this.fParameters.length) {
            Parameter parameter = this.fParameters[index];
            Label label = new Label(container, 0);
            label.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
            label.setText(String.format("%s:", parameter.getName()));
            Text text = new Text(container, 2048);
            text.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            String defaultValue = ScriptParameter.Helper.getDefaultValue((Parameter)parameter);
            if ("org.eclipse.ease.modules.ScriptParameter.null".equals(defaultValue)) {
                text.setText("<null>");
            } else if (defaultValue != null) {
                text.setText(defaultValue);
            }
            try {
                String tooltip = this.getHelpMessage(this.fMethod, index);
                label.setToolTipText(tooltip);
                text.setToolTipText(tooltip);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++index;
        }
        return area;
    }

    private String getHelpMessage(Method method, int parameterIndex) throws Exception {
        URL helpLocation = ModuleHelp.getModuleHelpLocation(ModulesTools.getDeclaringModule(method));
        if (helpLocation != null) {
            MethodHelp methodHelp = new ModuleHelp(helpLocation).getMethodHelp(method);
            return methodHelp.getParameterDescriptions().get(parameterIndex).getDescription();
        }
        return null;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void okPressed() {
        Composite dialogArea = (Composite)this.getDialogArea();
        Composite container = (Composite)dialogArea.getChildren()[1];
        Control[] controlArray = container.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof Text) {
                this.fUserInput.add(((Text)child).getText());
            }
            ++n2;
        }
        super.okPressed();
    }

    protected Point getInitialSize() {
        return new Point(550, 400);
    }

    public List<String> getParameters() {
        return this.fUserInput;
    }
}

