/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.modules.ui;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ease.modules.ModuleDefinition;
import org.eclipse.ease.tools.StringTools;
import org.eclipse.ease.ui.modules.ui.ModulesTools;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;

public class ModulesDragListener
implements DragSourceListener {
    private final TreeViewer fTreeViewer;
    private final TableViewer fTableViewer;

    public ModulesDragListener(TreeViewer viewer) {
        this.fTreeViewer = viewer;
        this.fTableViewer = null;
    }

    public ModulesDragListener(TableViewer viewer) {
        this.fTableViewer = viewer;
        this.fTreeViewer = null;
    }

    public void dragStart(DragSourceEvent event) {
        event.doit = !(event.data instanceof IPath);
    }

    public void dragSetData(DragSourceEvent event) {
        if (LocalSelectionTransfer.getTransfer().isSupportedType(event.dataType)) {
            LocalSelectionTransfer.getTransfer().setSelection((ISelection)this.getSelection());
        } else if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
            Object firstElement = this.getSelection().getFirstElement();
            if (firstElement instanceof ModulesTools.ModuleEntry) {
                firstElement = ((ModulesTools.ModuleEntry)firstElement).getEntry();
            }
            StringBuilder data = new StringBuilder();
            if (firstElement instanceof ModuleDefinition) {
                data.append("loadModule('").append(((ModuleDefinition)firstElement).getPath().toString()).append("');" + StringTools.LINE_DELIMITER);
            } else if (firstElement instanceof Field) {
                data.append(((Field)firstElement).getName());
            } else if (firstElement instanceof Method) {
                data.append((CharSequence)ModulesTools.getSignature((Method)firstElement, false)).append(";" + StringTools.LINE_DELIMITER);
            }
            event.data = data.toString();
        }
    }

    protected IStructuredSelection getSelection() {
        if (this.fTreeViewer != null) {
            return this.fTreeViewer.getStructuredSelection();
        }
        if (this.fTableViewer != null) {
            return this.fTableViewer.getStructuredSelection();
        }
        return StructuredSelection.EMPTY;
    }

    public void dragFinished(DragSourceEvent event) {
    }
}

