/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.core.refactoring;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.resource.Resources;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCorePlugin;
import org.eclipse.text.edits.MalformedTreeException;

public class Changes {
    public static RefactoringStatus validateModifiesFiles(IFile[] filesToModify) {
        RefactoringStatus result = new RefactoringStatus();
        IStatus status = Resources.checkInSync((IResource[])filesToModify);
        if (!status.isOK()) {
            result.merge(RefactoringStatus.create(status));
        }
        if (!(status = Resources.makeCommittable((IResource[])filesToModify, null)).isOK()) {
            result.merge(RefactoringStatus.create(status));
            if (!result.hasFatalError()) {
                result.addFatalError(RefactoringCoreMessages.Changes_validateEdit);
            }
        }
        return result;
    }

    public static RefactoringStatus checkInSync(IFile[] filesToModify) {
        RefactoringStatus result = new RefactoringStatus();
        IStatus status = Resources.checkInSync((IResource[])filesToModify);
        if (!status.isOK()) {
            result.merge(RefactoringStatus.create(status));
        }
        return result;
    }

    public static CoreException asCoreException(BadLocationException e) {
        String message = e.getMessage();
        if (message == null) {
            message = "BadLocationException";
        }
        return new CoreException((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), 10001, message, (Throwable)e));
    }

    public static CoreException asCoreException(MalformedTreeException e) {
        String message = e.getMessage();
        if (message == null) {
            message = "MalformedTreeException";
        }
        return new CoreException((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), 10001, message, (Throwable)e));
    }

    private Changes() {
    }
}

