/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.debugging.events.model;

import org.eclipse.ease.debugging.events.AbstractEvent;
import org.eclipse.ease.debugging.events.model.IModelRequest;

public class ResumeRequest
extends AbstractEvent
implements IModelRequest {
    private final int fType;
    private final Object fThread;

    public static String getTypeName(int type) {
        switch (type) {
            case 32: {
                return "CLIENT_REQUEST";
            }
            case 1: {
                return "STEP_INTO";
            }
            case 2: {
                return "STEP_OVER";
            }
            case 4: {
                return "STEP_RETURN";
            }
            case 8: {
                return "STEP_END";
            }
            case 16: {
                return "BREAKPOINT";
            }
        }
        return "<unknown>:" + type;
    }

    public ResumeRequest(int type, Object thread) {
        this.fType = type;
        this.fThread = thread;
    }

    public int getType() {
        return this.fType;
    }

    @Override
    public Object getThread() {
        return this.fThread;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " (" + ResumeRequest.getTypeName(this.fType) + ")";
    }
}

