/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.model;

import java.net.URI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.model.IRepositoryElement;
import org.eclipse.equinox.internal.p2.ui.model.RemoteQueriedElement;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.repository.IRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;

public class ArtifactRepositoryElement
extends RemoteQueriedElement
implements IRepositoryElement<IArtifactKey> {
    URI location;
    IArtifactRepository repo;
    boolean isEnabled;

    public ArtifactRepositoryElement(Object parent, URI location) {
        this(parent, location, true);
    }

    public ArtifactRepositoryElement(Object parent, URI location, boolean isEnabled) {
        super(parent);
        this.location = location;
        this.isEnabled = isEnabled;
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IArtifactRepository.class) {
            return (T)this.getRepository(null);
        }
        if (adapter == IRepository.class) {
            return (T)this.getRepository(null);
        }
        return super.getAdapter(adapter);
    }

    @Override
    protected String getImageId(Object obj) {
        return "obj/artifact_repo_obj.png";
    }

    @Override
    public String getLabel(Object o) {
        String name = this.getName();
        if (name != null && name.length() > 0) {
            return name;
        }
        return URIUtil.toUnencodedString((URI)this.getLocation());
    }

    public IArtifactRepository getRepository(IProgressMonitor monitor) {
        if (this.repo == null) {
            try {
                this.repo = this.getArtifactRepositoryManager().loadRepository(this.location, monitor);
            }
            catch (ProvisionException e) {
                this.getProvisioningUI().getRepositoryTracker().reportLoadFailure(this.location, e);
            }
            catch (OperationCanceledException operationCanceledException) {
                // empty catch block
            }
        }
        return this.repo;
    }

    @Override
    public URI getLocation() {
        return this.location;
    }

    @Override
    public String getName() {
        String name = this.getArtifactRepositoryManager().getRepositoryProperty(this.location, "p2.nickname");
        if (name == null) {
            name = this.getArtifactRepositoryManager().getRepositoryProperty(this.location, "name");
        }
        if (name == null) {
            name = "";
        }
        return name;
    }

    @Override
    public String getDescription() {
        if (this.getProvisioningUI().getRepositoryTracker().hasNotFoundStatusBeenReported(this.location)) {
            return ProvUIMessages.RepositoryElement_NotFound;
        }
        String description = this.getArtifactRepositoryManager().getRepositoryProperty(this.location, "description");
        if (description == null) {
            return "";
        }
        return description;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    @Override
    protected int getDefaultQueryType() {
        return 7;
    }

    @Override
    public IQueryable<?> getQueryable() {
        if (this.queryable == null) {
            this.queryable = this.getRepository((IProgressMonitor)new NullProgressMonitor());
        }
        return this.queryable;
    }

    IArtifactRepositoryManager getArtifactRepositoryManager() {
        return ProvUI.getArtifactRepositoryManager(this.getProvisioningUI().getSession());
    }
}

