/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.ust.core.analysis.debuginfo;

import java.io.File;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.lttng2.ust.core.analysis.debuginfo.FileOffsetMapper;
import org.eclipse.tracecompass.internal.lttng2.ust.core.analysis.debuginfo.UstDebugInfoSymbolProvider;
import org.eclipse.tracecompass.lttng2.ust.core.analysis.debuginfo.BinaryCallsite;
import org.eclipse.tracecompass.lttng2.ust.core.analysis.debuginfo.FunctionLocation;
import org.eclipse.tracecompass.lttng2.ust.core.analysis.debuginfo.Messages;
import org.eclipse.tracecompass.lttng2.ust.core.analysis.debuginfo.UstDebugInfoBinaryAspect;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;

public class UstDebugInfoFunctionAspect
implements ITmfEventAspect<FunctionLocation> {
    public static final UstDebugInfoFunctionAspect INSTANCE = new UstDebugInfoFunctionAspect();

    private UstDebugInfoFunctionAspect() {
    }

    public String getName() {
        return NonNullUtils.nullToEmptyString((Object)Messages.UstDebugInfoAnalysis_FunctionAspectName);
    }

    public String getHelpText() {
        return NonNullUtils.nullToEmptyString((Object)Messages.UstDebugInfoAnalysis_FunctionAspectHelpText);
    }

    public @Nullable FunctionLocation resolve(ITmfEvent event) {
        BinaryCallsite bc = UstDebugInfoBinaryAspect.INSTANCE.resolve(event);
        if (bc == null) {
            return null;
        }
        String functionName = UstDebugInfoSymbolProvider.getFunctionNameFromSS(bc, event.getTrace());
        if (functionName != null) {
            return new FunctionLocation(functionName, null);
        }
        return UstDebugInfoFunctionAspect.getFunctionFromBinaryLocation(bc);
    }

    public static @Nullable FunctionLocation getFunctionFromBinaryLocation(BinaryCallsite bc) {
        String functionName = FileOffsetMapper.getFunctionNameFromOffset(new File(bc.getBinaryFilePath()), bc.getBuildId(), bc.getOffset());
        if (functionName == null) {
            return null;
        }
        return new FunctionLocation(functionName, null);
    }
}

