/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.ui;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionControlService;

public class ServicePropertyTester
extends PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (receiver instanceof IRemoteConnection) {
            IRemoteConnection connection = (IRemoteConnection)receiver;
            if (property.equals("hasConnectionTypeService")) {
                if (args.length > 0 && args[0] instanceof String) {
                    String serviceName = (String)args[0];
                    try {
                        Class<?> service = Class.forName(serviceName);
                        return connection.getConnectionType().hasService(service);
                    }
                    catch (ClassNotFoundException e) {
                        return false;
                    }
                }
            } else if (property.equals("hasConnectionService")) {
                if (args.length > 0 && args[0] instanceof String) {
                    String serviceName = (String)args[0];
                    try {
                        Class<?> service = Class.forName(serviceName);
                        return connection.hasService(service);
                    }
                    catch (ClassNotFoundException e) {
                        return false;
                    }
                }
            } else {
                if (property.equals("canDelete")) {
                    return connection.getConnectionType().canRemove();
                }
                if (property.equals("canOpen")) {
                    IRemoteConnectionControlService controlService = (IRemoteConnectionControlService)connection.getService(IRemoteConnectionControlService.class);
                    if (controlService != null) {
                        return !connection.isOpen();
                    }
                    return false;
                }
                if (property.equals("canClose")) {
                    IRemoteConnectionControlService controlService = (IRemoteConnectionControlService)connection.getService(IRemoteConnectionControlService.class);
                    if (controlService != null) {
                        return connection.isOpen();
                    }
                    return false;
                }
            }
        }
        return false;
    }
}

