/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.batch;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import org.eclipse.wst.jsdt.core.UnimplementedException;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.batch.ClasspathLocation;
import org.eclipse.wst.jsdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.wst.jsdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.wst.jsdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.wst.jsdt.internal.compiler.impl.ITypeRequestor;
import org.eclipse.wst.jsdt.internal.oaametadata.LibraryAPIs;
import org.eclipse.wst.jsdt.internal.oaametadata.MetadataReader;

public class ClasspathMetadataFile
extends ClasspathLocation {
    protected File file;
    protected Hashtable packageCache;
    String packageName;
    protected char[] normalizedPath;
    String encoding;
    LibraryAPIs apis;
    NameEnvironmentAnswer foundAnswer;

    public ClasspathMetadataFile(File file, String encoding, AccessRuleSet accessRuleSet, String destinationPath) {
        super(accessRuleSet, destinationPath);
        this.file = file;
        this.packageName = file.getName();
        this.encoding = encoding;
    }

    @Override
    public NameEnvironmentAnswer findBinding(char[] typeName, String qualifiedPackageName, int type, ITypeRequestor requestor) {
        if (this.foundAnswer == null) {
            this.parseFile(requestor);
        }
        if (this.apis == null) {
            return null;
        }
        String name = new String(typeName);
        if ((type & 3) != 0 && this.apis.getGlobalVar(name) != null) {
            return this.foundAnswer;
        }
        if ((type & 4) != 0 && this.apis.getClass(name) != null) {
            return this.foundAnswer;
        }
        if ((type & 8) != 0 && this.apis.getGlobalMethod(name) != null) {
            return this.foundAnswer;
        }
        return null;
    }

    private void parseFile(ITypeRequestor requestor) {
        CompilationUnit compilationUnit = new CompilationUnit(null, this.file.getAbsolutePath(), this.encoding);
        compilationUnit.packageName = new char[][]{this.packageName.toCharArray()};
        this.apis = MetadataReader.readAPIsFromFile(this.file.getAbsolutePath());
        this.foundAnswer = new NameEnvironmentAnswer(this.apis);
    }

    @Override
    public NameEnvironmentAnswer findClass(char[] typeName, String qualifiedPackageName, String qualifiedBinaryFileName) {
        return this.findClass(typeName, qualifiedPackageName, qualifiedBinaryFileName, false);
    }

    @Override
    public NameEnvironmentAnswer findClass(char[] typeName, String qualifiedPackageName, String qualifiedBinaryFileName, boolean asBinaryOnly) {
        if (!this.isPackage(qualifiedPackageName)) {
            return null;
        }
        throw new UnimplementedException();
    }

    @Override
    public void initialize() throws IOException {
    }

    @Override
    public boolean isPackage(String qualifiedPackageName) {
        return this.packageName.equals(qualifiedPackageName);
    }

    @Override
    public void reset() {
        this.packageCache = null;
    }

    public String toString() {
        return "Classpath for file " + this.file.getPath();
    }

    @Override
    public char[] normalizedPath() {
        if (this.normalizedPath == null) {
            char[] rawName = this.file.getPath().toCharArray();
            if (File.separatorChar == '\\') {
                CharOperation.replace(rawName, '\\', '/');
            }
            this.normalizedPath = CharOperation.subarray(rawName, 0, CharOperation.lastIndexOf('.', rawName));
        }
        return this.normalizedPath;
    }

    @Override
    public String getPath() {
        return this.file.getPath();
    }

    @Override
    public char[][][] findTypeNames(String qualifiedPackageName) {
        throw new UnimplementedException("implement");
    }
}

