/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import org.eclipse.wst.jsdt.core.IExportContainer;
import org.eclipse.wst.jsdt.core.IExportDeclaration;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.internal.core.CompilationUnit;
import org.eclipse.wst.jsdt.internal.core.ExportDeclaration;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.JavaElementInfo;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.SourceRange;
import org.eclipse.wst.jsdt.internal.core.SourceRefElement;
import org.eclipse.wst.jsdt.internal.core.util.MementoTokenizer;

public class ExportContainer
extends SourceRefElement
implements IExportContainer {
    protected ExportContainer(CompilationUnit parent) {
        super(parent);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ExportContainer)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public int getElementType() {
        return 15;
    }

    @Override
    public IJavaScriptElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner workingCopyOwner) {
        switch (token.charAt(0)) {
            case '!': {
                return this.getHandleUpdatingCountFromMemento(memento, workingCopyOwner);
            }
            case '#': {
                if (memento.hasMoreTokens()) {
                    String exportName = memento.nextToken();
                    JavaElement exportDecl = (JavaElement)((Object)this.getExport(exportName));
                    return exportDecl.getHandleFromMemento(memento, workingCopyOwner);
                }
                return this;
            }
        }
        return null;
    }

    @Override
    protected char getHandleMementoDelimiter() {
        return '#';
    }

    @Override
    public IExportDeclaration getExport(String exportName) {
        boolean isOnDemand;
        int index = exportName.indexOf(".*");
        boolean bl = isOnDemand = index != -1;
        if (isOnDemand) {
            exportName = new String(exportName.substring(0, index));
        }
        return new ExportDeclaration(this, exportName);
    }

    @Override
    public IJavaScriptElement getPrimaryElement(boolean checkOwner) {
        CompilationUnit cu = (CompilationUnit)this.parent;
        if (checkOwner && cu.isPrimary()) {
            return this;
        }
        return cu.getExportContainer();
    }

    @Override
    public ISourceRange getSourceRange() throws JavaScriptModelException {
        SourceRange range;
        IJavaScriptElement[] exports = this.getChildren();
        if (exports.length > 0) {
            ISourceRange firstRange = ((ISourceReference)((Object)exports[0])).getSourceRange();
            ISourceRange lastRange = ((ISourceReference)((Object)exports[exports.length - 1])).getSourceRange();
            range = new SourceRange(firstRange.getOffset(), lastRange.getOffset() + lastRange.getLength() - firstRange.getOffset());
        } else {
            range = new SourceRange(0, 0);
        }
        return range;
    }

    @Override
    public String readableName() {
        return null;
    }

    @Override
    protected void toString(int tab, StringBuffer buffer) {
        Object info = JavaModelManager.getJavaModelManager().peekAtInfo(this);
        if (info == null || !(info instanceof JavaElementInfo)) {
            return;
        }
        IJavaScriptElement[] children = ((JavaElementInfo)info).getChildren();
        int i = 0;
        while (i < children.length) {
            if (i > 0) {
                buffer.append("\n");
            }
            ((JavaElement)children[i]).toString(tab, buffer);
            ++i;
        }
    }

    @Override
    protected void toStringInfo(int tab, StringBuffer buffer, Object info, boolean showResolvedInfo) {
        buffer.append(this.tabString(tab));
        buffer.append("<export container>");
        if (info == null) {
            buffer.append(" (not open)");
        }
    }
}

