/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.JsGlobalScopeContainerInitializer;
import org.eclipse.wst.jsdt.internal.compiler.util.SuffixConstants;
import org.eclipse.wst.jsdt.internal.core.ClassFile;
import org.eclipse.wst.jsdt.internal.core.JavaElementInfo;
import org.eclipse.wst.jsdt.internal.core.JavaModelStatus;
import org.eclipse.wst.jsdt.internal.core.LibraryFragmentRoot;
import org.eclipse.wst.jsdt.internal.core.LibraryPackageFragmentInfo;
import org.eclipse.wst.jsdt.internal.core.MetadataFile;
import org.eclipse.wst.jsdt.internal.core.Openable;
import org.eclipse.wst.jsdt.internal.core.OpenableElementInfo;
import org.eclipse.wst.jsdt.internal.core.PackageFragment;
import org.eclipse.wst.jsdt.internal.core.PackageFragmentRoot;
import org.eclipse.wst.jsdt.internal.core.util.Messages;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class LibraryPackageFragment
extends PackageFragment
implements SuffixConstants {
    static final String[] DEFAULT_PACKAGE = new String[]{""};
    static final Object[] NO_OBJECTS = new Object[0];

    protected LibraryPackageFragment(PackageFragmentRoot root, String[] names) {
        super(root, names);
    }

    protected boolean computeChildren(OpenableElementInfo info) {
        String name = this.getPackageFragmentRoot().getPath().toOSString();
        ClassFile classFile = new ClassFile(this, name);
        IJavaScriptElement[] children = new IJavaScriptElement[]{classFile};
        info.setChildren(children);
        return true;
    }

    @Override
    public boolean containsJavaResources() throws JavaScriptModelException {
        return true;
    }

    @Override
    public IJavaScriptUnit createCompilationUnit(String cuName, String contents, boolean force, IProgressMonitor monitor) throws JavaScriptModelException {
        throw new JavaScriptModelException(new JavaModelStatus(976, this));
    }

    @Override
    protected Object createElementInfo() {
        return new LibraryPackageFragmentInfo();
    }

    @Override
    protected void generateInfos(Object info, HashMap newElements, IProgressMonitor pm) throws JavaScriptModelException {
        if (!this.getLibraryFragmentRoot().isDirectory()) {
            Openable openableParent = (Openable)this.parent;
            if (!openableParent.isOpen()) {
                openableParent.generateInfos(openableParent.createElementInfo(), newElements, pm);
            }
        } else {
            super.generateInfos(info, newElements, pm);
        }
    }

    @Override
    protected boolean buildStructure(OpenableElementInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws JavaScriptModelException {
        if (!this.getLibraryFragmentRoot().isDirectory()) {
            return true;
        }
        HashSet<IClassFile> vChildren = new HashSet<IClassFile>();
        try {
            File file = this.getUnderlyingFile();
            File[] members = file.listFiles();
            if (members != null && members.length > 0) {
                int i = 0;
                while (i < members.length) {
                    File child = members[i];
                    if (child.isFile()) {
                        IClassFile childElement;
                        if (org.eclipse.wst.jsdt.internal.compiler.util.Util.isJavaFileName(child.getName())) {
                            childElement = this.getClassFile(child.getName());
                            vChildren.add(childElement);
                        } else if (Util.isMetadataFileName(child.getName())) {
                            childElement = this.getClassFile(child.getName());
                            vChildren.add(childElement);
                        }
                    }
                    ++i;
                }
            }
        }
        catch (CoreException e) {
            throw new JavaScriptModelException(e);
        }
        IJavaScriptElement[] children = new IJavaScriptElement[vChildren.size()];
        vChildren.toArray(children);
        info.setChildren(children);
        return true;
    }

    @Override
    public IClassFile[] getClassFiles() throws JavaScriptModelException {
        ArrayList list = this.getChildrenOfType(6);
        IClassFile[] array = new IClassFile[list.size()];
        list.toArray(array);
        return array;
    }

    @Override
    public IJavaScriptUnit[] getJavaScriptUnits() {
        return NO_COMPILATION_UNITS;
    }

    @Override
    public IResource getCorrespondingResource() {
        return null;
    }

    @Override
    public Object[] getNonJavaScriptResources() throws JavaScriptModelException {
        if (this.isDefaultPackage()) {
            return JavaElementInfo.NO_NON_JAVA_RESOURCES;
        }
        return this.storedNonJavaResources();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    protected Object[] storedNonJavaResources() throws JavaScriptModelException {
        return NO_OBJECTS;
    }

    @Override
    protected boolean resourceExists() {
        return this.getPackageFragmentRoot().resourceExists();
    }

    protected LibraryFragmentRoot getLibraryFragmentRoot() {
        return (LibraryFragmentRoot)this.getPackageFragmentRoot();
    }

    @Override
    public IClassFile getClassFile(String classFileName) {
        if (!org.eclipse.wst.jsdt.internal.compiler.util.Util.isClassFileName(classFileName) && !Util.isMetadataFileName(classFileName)) {
            throw new IllegalArgumentException(Messages.element_invalidClassFileName);
        }
        LibraryFragmentRoot libraryFragmentRoot = this.getLibraryFragmentRoot();
        if (!libraryFragmentRoot.isDirectory()) {
            IPath path = this.getLibraryFragmentRoot().getPath();
            if (path.toOSString().endsWith(classFileName) || path.isPrefixOf((IPath)new Path(classFileName))) {
                return new ClassFile(this, path.toOSString());
            }
        } else {
            String filename = "";
            filename = this.getFile() != null ? String.valueOf(this.getFile().getAbsolutePath()) + File.separator + classFileName : classFileName;
            return !Util.isMetadataFileName(classFileName) ? new ClassFile(this, filename) : new MetadataFile(this, filename);
        }
        return super.getClassFile(classFileName);
    }

    @Override
    public String getDisplayName() {
        if (this.parent instanceof LibraryFragmentRoot) {
            JsGlobalScopeContainerInitializer initializer = ((LibraryFragmentRoot)this.parent).getContainerInitializer();
            if (initializer == null) {
                return this.getPath().removeLastSegments(1).toString();
            }
            String name = initializer.getDescription(this.getPath(), this.getJavaScriptProject());
            if (name != null) {
                return name;
            }
        }
        return this.parent.getPath().lastSegment();
    }

    public File getUnderlyingFile() throws JavaScriptModelException {
        File file = this.getLibraryFragmentRoot().getFile();
        if (file == null) {
            return null;
        }
        if (this.names.length == 0) {
            return file;
        }
        String[] segs = this.names;
        int i = 0;
        while (i < segs.length) {
            File child = new File(file, segs[i]);
            if (!child.exists()) {
                throw this.newNotPresentException();
            }
            file = child;
            ++i;
        }
        return file;
    }

    public File getFile() {
        File file = this.getLibraryFragmentRoot().getFile();
        int length = this.names.length;
        if (length == 0) {
            return file;
        }
        String[] segs = this.names;
        int i = 0;
        while (i < segs.length) {
            File child = new File(file, segs[i]);
            if (!child.exists()) {
                return null;
            }
            file = child;
            ++i;
        }
        return file;
    }
}

