/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.dom.fragments;

import org.eclipse.core.runtime.Assert;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.internal.corext.dom.JdtASTMatcher;
import org.eclipse.wst.jsdt.internal.corext.dom.fragments.ASTFragment;
import org.eclipse.wst.jsdt.internal.corext.dom.fragments.ASTFragmentFactory;
import org.eclipse.wst.jsdt.internal.corext.dom.fragments.ASTMatchingFragmentFinder;
import org.eclipse.wst.jsdt.internal.corext.dom.fragments.IASTFragment;

class SimpleFragment
extends ASTFragment {
    private final ASTNode fNode;

    SimpleFragment(ASTNode node) {
        Assert.isNotNull((Object)node);
        this.fNode = node;
    }

    @Override
    public IASTFragment[] getMatchingFragmentsWithNode(ASTNode node) {
        if (!JdtASTMatcher.doNodesMatch(this.getAssociatedNode(), node)) {
            return new IASTFragment[0];
        }
        IASTFragment match = ASTFragmentFactory.createFragmentForFullSubtree(node);
        Assert.isTrue((match.matches(this) || this.matches(match) ? 1 : 0) != 0);
        return new IASTFragment[]{match};
    }

    @Override
    public boolean matches(IASTFragment other) {
        return other.getClass().equals(this.getClass()) && JdtASTMatcher.doNodesMatch(other.getAssociatedNode(), this.getAssociatedNode());
    }

    @Override
    public IASTFragment[] getSubFragmentsMatching(IASTFragment toMatch) {
        return ASTMatchingFragmentFinder.findMatchingFragments(this.getAssociatedNode(), (ASTFragment)toMatch);
    }

    @Override
    public int getStartPosition() {
        return this.fNode.getStartPosition();
    }

    @Override
    public int getLength() {
        return this.fNode.getLength();
    }

    @Override
    public ASTNode getAssociatedNode() {
        return this.fNode;
    }

    @Override
    public void replace(ASTRewrite rewrite, ASTNode replacement, TextEditGroup textEditGroup) {
        rewrite.replace(this.fNode, replacement, textEditGroup);
    }

    public int hashCode() {
        return this.fNode.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleFragment other = (SimpleFragment)obj;
        return this.fNode.equals((Object)other.fNode);
    }
}

