/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.browsing;

import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptModel;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.ProductProperties;
import org.eclipse.wst.jsdt.internal.ui.browsing.JavaBrowsingPart;
import org.eclipse.wst.jsdt.internal.ui.browsing.LogicalPackage;
import org.eclipse.wst.jsdt.internal.ui.browsing.ProjectAndSourceFolderContentProvider;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ColoredViewersManager;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.FilterUpdater;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ProblemTreeViewer;
import org.eclipse.wst.jsdt.ui.actions.ProjectActionGroup;

public class ProjectsView
extends JavaBrowsingPart {
    private FilterUpdater fFilterUpdater;

    @Override
    protected StructuredViewer createViewer(Composite parent) {
        ProblemTreeViewer result = new ProblemTreeViewer(parent, 2);
        ColoredViewersManager.install((StructuredViewer)result);
        this.fFilterUpdater = new FilterUpdater(result);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.fFilterUpdater);
        return result;
    }

    @Override
    public void dispose() {
        if (this.fFilterUpdater != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.fFilterUpdater);
        }
        super.dispose();
    }

    @Override
    public Object getAdapter(Class key) {
        if (key == IShowInTargetList.class) {
            return new IShowInTargetList(){

                public String[] getShowInTargetIds() {
                    String explorerViewID = ProductProperties.getProperty("idPerspectiveHierarchyView");
                    if (explorerViewID != null) {
                        return new String[]{explorerViewID, "org.eclipse.wst.jsdt.ui.PackageExplorer", "org.eclipse.ui.navigator.ProjectExplorer"};
                    }
                    return new String[]{"org.eclipse.wst.jsdt.ui.PackageExplorer", "org.eclipse.ui.navigator.ProjectExplorer"};
                }
            };
        }
        return super.getAdapter(key);
    }

    @Override
    protected IContentProvider createContentProvider() {
        return new ProjectAndSourceFolderContentProvider(this);
    }

    @Override
    protected String getHelpContextId() {
        return "org.eclipse.wst.jsdt.ui.projects_view_context";
    }

    @Override
    protected String getLinkToEditorKey() {
        return "org.eclipse.wst.jsdt.ui.browsing.projectstoeditor";
    }

    @Override
    protected void hookViewerListeners() {
        super.hookViewerListeners();
        this.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object element;
                TreeViewer viewer = (TreeViewer)ProjectsView.this.getViewer();
                if (viewer.isExpandable(element = ((IStructuredSelection)event.getSelection()).getFirstElement())) {
                    viewer.setExpandedState(element, !viewer.getExpandedState(element));
                }
            }
        });
    }

    @Override
    protected void setInitialInput() {
        IJavaScriptModel root = JavaScriptCore.create((IWorkspaceRoot)JavaScriptPlugin.getWorkspace().getRoot());
        this.getViewer().setInput((Object)root);
        this.updateTitle();
    }

    @Override
    protected boolean isValidInput(Object element) {
        return element instanceof IJavaScriptModel;
    }

    @Override
    protected boolean isValidElement(Object element) {
        return element instanceof IJavaScriptProject || element instanceof IPackageFragmentRoot;
    }

    @Override
    protected IJavaScriptElement findElementToSelect(IJavaScriptElement je) {
        if (je == null) {
            return null;
        }
        switch (je.getElementType()) {
            case 1: {
                return null;
            }
            case 2: {
                return je;
            }
            case 3: {
                if (je.getElementName().equals("")) {
                    return je.getParent();
                }
                return je;
            }
        }
        return this.findElementToSelect(je.getParent());
    }

    @Override
    protected void setInput(Object input) {
        if (input != null) {
            super.setInput(input);
        } else {
            this.getViewer().setSelection(null);
        }
    }

    @Override
    protected void createActions() {
        super.createActions();
        this.fActionGroups.addGroup(new ProjectActionGroup((IViewPart)this));
    }

    @Override
    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!this.needsToProcessSelectionChanged(part, selection)) {
            return;
        }
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)selection;
            for (Object selectedElement : sel) {
                if (!(selectedElement instanceof LogicalPackage)) continue;
                selection = new StructuredSelection((Object)((LogicalPackage)((Object)selectedElement)).getJavaProject());
                break;
            }
        }
        super.selectionChanged(part, selection);
    }
}

