/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.wst.jsdt.internal.ui.text.AbstractJavaScanner;
import org.eclipse.wst.jsdt.internal.ui.text.CombinedWordRule;
import org.eclipse.wst.jsdt.internal.ui.text.JavaWhitespaceDetector;
import org.eclipse.wst.jsdt.internal.ui.text.JavaWordDetector;
import org.eclipse.wst.jsdt.ui.text.IColorManager;

public final class JavaCodeScanner
extends AbstractJavaScanner {
    private static final String SOURCE_VERSION = "org.eclipse.wst.jsdt.core.compiler.source";
    static String[] fgKeywords = new String[]{"break", "case", "catch", "class", "const", "continue", "default", "delete", "debugger", "do", "else", "export", "extends", "finally", "for", "function", "if", "implements", "in", "instanceof", "interface", "new", "package", "private", "protected", "public", "static", "super", "switch", "this", "throw", "try", "typeof", "var", "while", "with", "enum", "let", "of", "import", "yield", "function*"};
    private static final String RETURN = "return";
    private static String[] fgConstants = new String[]{"false", "null", "true", "undefined"};
    private static final String ANNOTATION_BASE_KEY = "semanticHighlighting.annotation";
    private static final String ANNOTATION_COLOR_KEY = "semanticHighlighting.annotation.color";
    private static String[] fgTokenProperties = new String[]{"java_keyword", "java_string", "java_default", "java_keyword_return", "java_operator", "java_bracket", "javascript_template_literal", "semanticHighlighting.annotation.color"};

    public JavaCodeScanner(IColorManager manager, IPreferenceStore store) {
        super(manager, store);
        this.initialize();
    }

    @Override
    protected String[] getTokenProperties() {
        return fgTokenProperties;
    }

    @Override
    protected List createRules() {
        ArrayList<Object> rules = new ArrayList<Object>();
        Token token = this.getToken("java_string");
        rules.add(new SingleLineRule("'", "'", (IToken)token, '\\'));
        rules.add(new WhitespaceRule((IWhitespaceDetector)new JavaWhitespaceDetector()));
        this.getPreferenceStore().getString(SOURCE_VERSION);
        JavaWordDetector wordDetector = new JavaWordDetector();
        token = this.getToken("java_default");
        CombinedWordRule combinedWordRule = new CombinedWordRule((IWordDetector)wordDetector, (IToken)token);
        token = this.getToken("java_operator");
        rules.add(new OperatorRule((IToken)token));
        token = this.getToken("java_bracket");
        rules.add(new BracketRule((IToken)token));
        CombinedWordRule.WordMatcher returnWordRule = new CombinedWordRule.WordMatcher();
        token = this.getToken("java_keyword_return");
        returnWordRule.addWord(RETURN, (IToken)token);
        combinedWordRule.addWordMatcher(returnWordRule);
        CombinedWordRule.WordMatcher wordRule = new CombinedWordRule.WordMatcher();
        token = this.getToken("java_keyword");
        int i = 0;
        while (i < fgKeywords.length) {
            wordRule.addWord(fgKeywords[i], (IToken)token);
            ++i;
        }
        i = 0;
        while (i < fgConstants.length) {
            wordRule.addWord(fgConstants[i], (IToken)token);
            ++i;
        }
        combinedWordRule.addWordMatcher(wordRule);
        rules.add(combinedWordRule);
        this.setDefaultReturnToken((IToken)this.getToken("java_default"));
        return rules;
    }

    @Override
    protected String getBoldKey(String colorKey) {
        if (ANNOTATION_COLOR_KEY.equals(colorKey)) {
            return "semanticHighlighting.annotation.bold";
        }
        return super.getBoldKey(colorKey);
    }

    @Override
    protected String getItalicKey(String colorKey) {
        if (ANNOTATION_COLOR_KEY.equals(colorKey)) {
            return "semanticHighlighting.annotation.italic";
        }
        return super.getItalicKey(colorKey);
    }

    @Override
    protected String getStrikethroughKey(String colorKey) {
        if (ANNOTATION_COLOR_KEY.equals(colorKey)) {
            return "semanticHighlighting.annotation.strikethrough";
        }
        return super.getStrikethroughKey(colorKey);
    }

    @Override
    protected String getUnderlineKey(String colorKey) {
        if (ANNOTATION_COLOR_KEY.equals(colorKey)) {
            return "semanticHighlighting.annotation.underline";
        }
        return super.getUnderlineKey(colorKey);
    }

    @Override
    public boolean affectsBehavior(PropertyChangeEvent event) {
        return event.getProperty().equals(SOURCE_VERSION) || super.affectsBehavior(event);
    }

    @Override
    public void adaptToPreferenceChange(PropertyChangeEvent event) {
        if (!event.getProperty().equals(SOURCE_VERSION) && super.affectsBehavior(event)) {
            super.adaptToPreferenceChange(event);
        }
    }

    private static final class BracketRule
    implements IRule {
        private final char[] JAVA_BRACKETS = new char[]{'(', ')', '{', '}', '[', ']'};
        private final IToken fToken;

        public BracketRule(IToken token) {
            this.fToken = token;
        }

        public boolean isBracket(char character) {
            int index = 0;
            while (index < this.JAVA_BRACKETS.length) {
                if (this.JAVA_BRACKETS[index] == character) {
                    return true;
                }
                ++index;
            }
            return false;
        }

        public IToken evaluate(ICharacterScanner scanner) {
            int character = scanner.read();
            if (this.isBracket((char)character)) {
                while (this.isBracket((char)(character = scanner.read()))) {
                }
                scanner.unread();
                return this.fToken;
            }
            scanner.unread();
            return Token.UNDEFINED;
        }
    }

    private static final class OperatorRule
    implements IRule {
        private final char[] JAVA_OPERATORS = new char[]{';', '.', '=', '/', '\\', '+', '-', '*', '<', '>', ':', '?', '!', ',', '|', '&', '^', '%', '~'};
        private final IToken fToken;

        public OperatorRule(IToken token) {
            this.fToken = token;
        }

        public boolean isOperator(char character) {
            int index = 0;
            while (index < this.JAVA_OPERATORS.length) {
                if (this.JAVA_OPERATORS[index] == character) {
                    return true;
                }
                ++index;
            }
            return false;
        }

        public IToken evaluate(ICharacterScanner scanner) {
            int character = scanner.read();
            if (this.isOperator((char)character)) {
                while (this.isOperator((char)(character = scanner.read()))) {
                }
                scanner.unread();
                return this.fToken;
            }
            scanner.unread();
            return Token.UNDEFINED;
        }
    }
}

