/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.wizards;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptModel;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.IViewPartInputProvider;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.wst.jsdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.wst.jsdt.ui.JavaScriptElementComparator;
import org.eclipse.wst.jsdt.ui.JavaScriptElementLabelProvider;
import org.eclipse.wst.jsdt.ui.StandardJavaScriptElementContentProvider;
import org.eclipse.wst.jsdt.ui.wizards.NewElementWizardPage;

public abstract class NewContainerWizardPage
extends NewElementWizardPage {
    protected static final String CONTAINER = "NewContainerWizardPage.container";
    protected IStatus fContainerStatus;
    private StringButtonDialogField fContainerDialogField;
    private IPackageFragmentRoot fCurrRoot;
    private IWorkspaceRoot fWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();

    public NewContainerWizardPage(String name) {
        super(name);
        ContainerFieldAdapter adapter = new ContainerFieldAdapter();
        this.fContainerDialogField = new StringButtonDialogField(adapter);
        this.fContainerDialogField.setDialogFieldListener(adapter);
        this.fContainerDialogField.setLabelText(this.getContainerLabel());
        this.fContainerDialogField.setButtonLabel(NewWizardMessages.NewContainerWizardPage_container_button);
        this.fContainerStatus = new StatusInfo();
        this.fCurrRoot = null;
    }

    protected String getContainerLabel() {
        return NewWizardMessages.NewContainerWizardPage_container_label;
    }

    protected void initContainerPage(IJavaScriptElement elem) {
        IPackageFragmentRoot initRoot = null;
        if (elem != null) {
            initRoot = JavaModelUtil.getPackageFragmentRoot(elem);
            try {
                IJavaScriptProject jproject;
                if ((initRoot == null || initRoot.getKind() != 1) && (jproject = elem.getJavaScriptProject()) != null) {
                    initRoot = null;
                    if (jproject.exists()) {
                        IPackageFragmentRoot[] roots = jproject.getPackageFragmentRoots();
                        int i = 0;
                        while (i < roots.length) {
                            if (roots[i].getKind() == 1) {
                                initRoot = roots[i];
                                break;
                            }
                            ++i;
                        }
                    }
                    if (initRoot == null) {
                        initRoot = jproject.getPackageFragmentRoot(jproject.getResource());
                    }
                }
            }
            catch (JavaScriptModelException e) {
                JavaScriptPlugin.log(e);
            }
        }
        this.setPackageFragmentRoot(initRoot, true);
    }

    protected IJavaScriptElement getInitialJavaElement(IStructuredSelection selection) {
        IResource resource;
        IAdaptable adaptable;
        Object selectedElement;
        IJavaScriptElement jelem = null;
        if (selection != null && !selection.isEmpty() && (selectedElement = selection.getFirstElement()) instanceof IAdaptable && (jelem = (IJavaScriptElement)(adaptable = (IAdaptable)selectedElement).getAdapter(IJavaScriptElement.class)) == null && (resource = (IResource)adaptable.getAdapter(IResource.class)) != null && resource.getType() != 8) {
            while (jelem == null && resource.getType() != 4) {
                resource = resource.getParent();
                jelem = (IJavaScriptElement)resource.getAdapter(IJavaScriptElement.class);
            }
            if (jelem == null) {
                jelem = JavaScriptCore.create((IResource)resource);
            }
        }
        if (jelem == null) {
            Object elem;
            IWorkbenchPart part = JavaScriptPlugin.getActivePage().getActivePart();
            if (part instanceof ContentOutline) {
                part = JavaScriptPlugin.getActivePage().getActiveEditor();
            }
            if (part instanceof IViewPartInputProvider && (elem = ((IViewPartInputProvider)part).getViewPartInput()) instanceof IJavaScriptElement) {
                jelem = (IJavaScriptElement)elem;
            }
        }
        if (jelem == null || jelem.getElementType() == 1) {
            try {
                IJavaScriptProject[] projects = JavaScriptCore.create((IWorkspaceRoot)this.getWorkspaceRoot()).getJavaScriptProjects();
                if (projects.length == 1) {
                    jelem = projects[0];
                }
            }
            catch (JavaScriptModelException e) {
                JavaScriptPlugin.log(e);
            }
        }
        return jelem;
    }

    protected ITextSelection getCurrentTextSelection() {
        ISelection selection;
        ISelectionProvider selectionProvider;
        IWorkbenchPart part = JavaScriptPlugin.getActivePage().getActivePart();
        if (part instanceof IEditorPart && (selectionProvider = part.getSite().getSelectionProvider()) != null && (selection = selectionProvider.getSelection()) instanceof ITextSelection) {
            return (ITextSelection)selection;
        }
        return null;
    }

    protected int getMaxFieldWidth() {
        return this.convertWidthInCharsToPixels(40);
    }

    protected void createContainerControls(Composite parent, int nColumns) {
        this.fContainerDialogField.doFillIntoGrid(parent, nColumns);
        LayoutUtil.setWidthHint((Control)this.fContainerDialogField.getTextControl(null), this.getMaxFieldWidth());
    }

    protected void setFocusOnContainer() {
        this.fContainerDialogField.setFocus();
    }

    private void containerChangeControlPressed(DialogField field) {
        IPackageFragmentRoot root = this.chooseContainer();
        if (root != null) {
            this.setPackageFragmentRoot(root, true);
        }
    }

    private void containerDialogFieldChanged(DialogField field) {
        if (field == this.fContainerDialogField) {
            this.fContainerStatus = this.containerChanged();
        }
        this.handleFieldChanged(CONTAINER);
    }

    protected IStatus containerChanged() {
        StatusInfo status = new StatusInfo();
        this.fCurrRoot = null;
        String str = this.getPackageFragmentRootText();
        if (str.length() == 0) {
            status.setError(NewWizardMessages.NewContainerWizardPage_error_EnterContainerName);
            return status;
        }
        Path path = new Path(str);
        IResource res = this.fWorkspaceRoot.findMember((IPath)path);
        if (res != null) {
            int resType = res.getType();
            if (resType == 4 || resType == 2) {
                IProject proj = res.getProject();
                if (!proj.isOpen()) {
                    status.setError(Messages.format(NewWizardMessages.NewContainerWizardPage_error_ProjectClosed, proj.getFullPath().toString()));
                    return status;
                }
                IJavaScriptProject jproject = JavaScriptCore.create((IProject)proj);
                this.fCurrRoot = jproject.getPackageFragmentRoot(res);
                if (res.exists()) {
                    try {
                        if (!proj.hasNature("org.eclipse.wst.jsdt.core.jsNature")) {
                            if (resType == 4) {
                                status.setError(NewWizardMessages.NewContainerWizardPage_warning_NotAJavaProject);
                            } else {
                                status.setWarning(NewWizardMessages.NewContainerWizardPage_warning_NotInAJavaProject);
                            }
                            return status;
                        }
                        if (this.fCurrRoot.isArchive()) {
                            status.setError(Messages.format(NewWizardMessages.NewContainerWizardPage_error_ContainerIsBinary, str));
                            return status;
                        }
                        if (this.fCurrRoot.getKind() == 2) {
                            status.setWarning(Messages.format(NewWizardMessages.NewContainerWizardPage_warning_inside_classfolder, str));
                        } else if (!jproject.isOnIncludepath((IJavaScriptElement)this.fCurrRoot)) {
                            status.setWarning(Messages.format(NewWizardMessages.NewContainerWizardPage_warning_NotOnClassPath, str));
                        }
                    }
                    catch (CoreException coreException) {
                        status.setWarning(NewWizardMessages.NewContainerWizardPage_warning_NotAJavaProject);
                    }
                }
                return status;
            }
            status.setError(Messages.format(NewWizardMessages.NewContainerWizardPage_error_NotAFolder, str));
            return status;
        }
        status.setError(Messages.format(NewWizardMessages.NewContainerWizardPage_error_ContainerDoesNotExist, str));
        return status;
    }

    protected void handleFieldChanged(String fieldName) {
    }

    protected IWorkspaceRoot getWorkspaceRoot() {
        return this.fWorkspaceRoot;
    }

    public IJavaScriptProject getJavaProject() {
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root != null) {
            return root.getJavaScriptProject();
        }
        return null;
    }

    public IPackageFragmentRoot getPackageFragmentRoot() {
        return this.fCurrRoot;
    }

    public String getPackageFragmentRootText() {
        return this.fContainerDialogField.getText();
    }

    public void setPackageFragmentRoot(IPackageFragmentRoot root, boolean canBeModified) {
        this.fCurrRoot = root;
        String str = root == null ? "" : root.getPath().makeRelative().toString();
        this.fContainerDialogField.setText(str);
        this.fContainerDialogField.setEnabled(canBeModified);
    }

    protected IPackageFragmentRoot chooseContainer() {
        IPackageFragmentRoot initElement = this.getPackageFragmentRoot();
        Class[] acceptedClasses = new Class[]{IPackageFragmentRoot.class, IJavaScriptProject.class};
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, false){

            @Override
            public boolean isSelectedValid(Object element) {
                try {
                    if (element instanceof IJavaScriptProject) {
                        IJavaScriptProject jproject = (IJavaScriptProject)element;
                        IPath path = jproject.getProject().getFullPath();
                        return jproject.findPackageFragmentRoot(path) != null;
                    }
                    if (element instanceof IPackageFragmentRoot) {
                        return ((IPackageFragmentRoot)element).getKind() == 1;
                    }
                    return true;
                }
                catch (JavaScriptModelException e) {
                    JavaScriptPlugin.log(e.getStatus());
                    return false;
                }
            }
        };
        acceptedClasses = new Class[]{IJavaScriptModel.class, IPackageFragmentRoot.class, IJavaScriptProject.class};
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses){

            @Override
            public boolean select(Viewer viewer, Object parent, Object element) {
                if (element instanceof IPackageFragmentRoot) {
                    try {
                        return ((IPackageFragmentRoot)element).getKind() == 1;
                    }
                    catch (JavaScriptModelException e) {
                        JavaScriptPlugin.log(e.getStatus());
                        return false;
                    }
                }
                return super.select(viewer, parent, element);
            }
        };
        StandardJavaScriptElementContentProvider provider = new StandardJavaScriptElementContentProvider();
        JavaScriptElementLabelProvider labelProvider = new JavaScriptElementLabelProvider(18);
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)provider);
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setComparator((ViewerComparator)new JavaScriptElementComparator());
        dialog.setTitle(NewWizardMessages.NewContainerWizardPage_ChooseSourceContainerDialog_title);
        dialog.setMessage(NewWizardMessages.NewContainerWizardPage_ChooseSourceContainerDialog_description);
        dialog.addFilter((ViewerFilter)filter);
        dialog.setInput((Object)JavaScriptCore.create((IWorkspaceRoot)this.fWorkspaceRoot));
        dialog.setInitialSelection((Object)initElement);
        dialog.setHelpAvailable(false);
        if (dialog.open() == 0) {
            Object element = dialog.getFirstResult();
            if (element instanceof IJavaScriptProject) {
                IJavaScriptProject jproject = (IJavaScriptProject)element;
                return jproject.getPackageFragmentRoot((IResource)jproject.getProject());
            }
            if (element instanceof IPackageFragmentRoot) {
                return (IPackageFragmentRoot)element;
            }
            return null;
        }
        return null;
    }

    private class ContainerFieldAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        private ContainerFieldAdapter() {
        }

        @Override
        public void changeControlPressed(DialogField field) {
            NewContainerWizardPage.this.containerChangeControlPressed(field);
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            NewContainerWizardPage.this.containerDialogFieldChanged(field);
        }
    }
}

