/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace;

import com.google.common.net.MediaType;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.TraceDownloadStatus;

public class DownloadTraceHttpHelper {
    private static final String CONTENT_DISPOSITION = "Content-Disposition";

    private DownloadTraceHttpHelper() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TraceDownloadStatus downloadTrace(String traceUrl, String destinationDir) {
        File destFile = null;
        try {
            URL url = new URL(traceUrl);
            HttpURLConnection httpConnection = (HttpURLConnection)url.openConnection();
            httpConnection.setConnectTimeout(120000);
            int responseCode = httpConnection.getResponseCode();
            if (responseCode != 200) {
                httpConnection.disconnect();
                return new TraceDownloadStatus(2, destFile, null);
            }
            String fileName = DownloadTraceHttpHelper.getFileName(httpConnection);
            destFile = new File(destinationDir, fileName);
            try {
                try {
                    FileUtils.copyURLToFile((URL)url, (File)destFile);
                    return new TraceDownloadStatus(0, destFile, null);
                }
                catch (IOException e) {
                    Activator.getDefault().logError("Unable to download from " + url.toString() + " to " + destFile.toString());
                    DownloadTraceHttpHelper.cleanDirectory(new File(destinationDir));
                    TraceDownloadStatus traceDownloadStatus = new TraceDownloadStatus(2, destFile, e);
                    httpConnection.disconnect();
                    return traceDownloadStatus;
                }
            }
            finally {
                httpConnection.disconnect();
            }
        }
        catch (SocketTimeoutException e) {
            return new TraceDownloadStatus(1, null, e);
        }
        catch (IOException e) {
            return new TraceDownloadStatus(2, null, e);
        }
    }

    public static TraceDownloadStatus downloadTraces(Collection<String> tracesUrl, String destinationDir) {
        TraceDownloadStatus status = new TraceDownloadStatus(0, null, null);
        for (String traceUrl : tracesUrl) {
            TraceDownloadStatus singleFileStatus = DownloadTraceHttpHelper.downloadTrace(traceUrl, destinationDir);
            status.add(singleFileStatus);
        }
        return status;
    }

    private static String getFileName(HttpURLConnection connection) {
        String contentDisposition;
        MediaType type;
        String fileName = DownloadTraceHttpHelper.getLastSegmentUrl(connection.getURL().toString());
        String contentType = connection.getContentType();
        if (contentType != null && (type = MediaType.parse((String)contentType)).is(MediaType.ANY_APPLICATION_TYPE) && (contentDisposition = connection.getHeaderField(CONTENT_DISPOSITION)) != null) {
            String[] content;
            String[] stringArray = content = contentDisposition.split(";");
            int n = content.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                if (string.contains("filename=")) {
                    int index = string.indexOf(34);
                    fileName = string.substring(index + 1, string.length() - 1);
                }
                ++n2;
            }
        }
        return fileName;
    }

    private static String getLastSegmentUrl(String url) {
        int indexFile = url.lastIndexOf(47);
        return url.substring(indexFile + 1, url.length());
    }

    private static void cleanDirectory(File dir) {
        try {
            FileUtils.deleteDirectory((File)dir);
        }
        catch (IOException e) {
            Activator.getDefault().logError("Unable to delete: " + dir.toString(), e);
        }
    }
}

