/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.markers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.math.Fraction;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.IMarkerEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.IMarkerEventSource;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.MarkerEvent;

@NonNullByDefault
public class PeriodicMarkerEventSource
implements IMarkerEventSource {
    private final String fCategory;
    private final Reference fReference;
    private final double fPeriod;
    private final long fPeriodInteger;
    private @Nullable Fraction fPeriodFraction;
    private final long fRollover;
    private final RGBA fColor1;
    private final @Nullable RGBA fColor2;
    private final boolean fForeground;

    public PeriodicMarkerEventSource(String category, Reference reference, double period, long rollover, RGBA color, boolean foreground) {
        this(category, reference, period, rollover, foreground, color, null);
    }

    public PeriodicMarkerEventSource(String category, Reference reference, double period, long rollover, RGBA color1, RGBA color2, boolean foreground) {
        this(category, reference, period, rollover, foreground, color1, color2);
    }

    private PeriodicMarkerEventSource(String category, Reference reference, double period, long rollover, boolean foreground, RGBA color1, @Nullable RGBA color2) {
        if (period <= 0.0) {
            throw new IllegalArgumentException("period cannot be less than or equal to zero");
        }
        if (rollover < 0L) {
            throw new IllegalArgumentException("rollover cannot be less than zero");
        }
        this.fCategory = category;
        this.fReference = reference;
        this.fPeriod = period;
        this.fPeriodInteger = (long)period;
        try {
            this.fPeriodFraction = Fraction.getFraction((double)(this.fPeriod - (double)this.fPeriodInteger));
        }
        catch (ArithmeticException e) {
            this.fPeriodFraction = null;
        }
        this.fRollover = rollover;
        this.fColor1 = color1;
        this.fColor2 = color2;
        this.fForeground = foreground;
    }

    @Override
    public List<String> getMarkerCategories() {
        return Arrays.asList(this.fCategory);
    }

    @Override
    public List<IMarkerEvent> getMarkerList(String category, long startTime, long endTime, long resolution, IProgressMonitor monitor) {
        if (startTime > endTime) {
            return Collections.emptyList();
        }
        ArrayList<IMarkerEvent> markers = new ArrayList<IMarkerEvent>();
        long time = startTime - Math.max(Math.round(1.5 * this.fPeriod), resolution);
        Reference reference = this.adjustReference(this.fReference, time);
        MarkerEvent markerEvent = null;
        while (true) {
            long index = Math.round((double)(time - reference.time) / this.fPeriod) + reference.index;
            long markerTime = Math.round((double)(index - reference.index) * this.fPeriod) + reference.time;
            long duration = this.fColor2 == null ? 0L : Math.round((double)(index + 1L - reference.index) * this.fPeriod) + reference.time - markerTime;
            long labelIndex = index;
            if (this.fRollover != 0L && (labelIndex %= this.fRollover) < 0L) {
                labelIndex += this.fRollover;
            }
            if ((markerTime >= startTime || markerTime + duration > startTime) && markerEvent != null) {
                markers.add(markerEvent);
            }
            if (this.isApplicable(labelIndex)) {
                RGBA color = this.fColor2 == null ? this.fColor1 : (index % 2L == 0L ? this.fColor1 : this.fColor2);
                markerEvent = new MarkerEvent(null, markerTime, duration, this.fCategory, color, this.getMarkerLabel(labelIndex), this.fForeground);
            } else {
                markerEvent = null;
            }
            if (markerTime > endTime) {
                if (markerEvent == null) break;
                markers.add(markerEvent);
                break;
            }
            time += Math.max(Math.round(this.fPeriod), resolution);
        }
        return markers;
    }

    private Reference adjustReference(Reference baseReference, long time) {
        long offsetIndex = (long)((double)(time - baseReference.time) / this.fPeriod);
        long offsetTime = 0L;
        Fraction fraction = this.fPeriodFraction;
        if (fraction != null) {
            offsetIndex -= offsetIndex % (long)fraction.getDenominator();
            offsetTime = offsetIndex * this.fPeriodInteger + offsetIndex / (long)fraction.getDenominator() * (long)fraction.getNumerator();
        } else {
            offsetTime = Math.round((double)offsetIndex * this.fPeriod);
        }
        Reference reference = new Reference(baseReference.time + offsetTime, baseReference.index + offsetIndex);
        return reference;
    }

    public String getMarkerLabel(long index) {
        return (String)NonNullUtils.checkNotNull((Object)Long.toString(index));
    }

    public boolean isApplicable(long index) {
        return true;
    }

    public static class Reference {
        public static final Reference ZERO = new Reference(0L, 0);
        private final long time;
        private final long index;

        public Reference(long time, int index) {
            this.time = time;
            this.index = index;
        }

        public Reference(long time, long index) {
            this.time = time;
            this.index = index;
        }

        public long getTime() {
            return this.time;
        }

        public long getIndex() {
            return this.index;
        }

        public String toString() {
            return String.format("[%d, %d]", this.time, this.index);
        }
    }
}

