/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.ui.views.property;

import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionHostService;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.messages.Messages;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TargetNodeComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.property.BasePropertySource;
import org.eclipse.tracecompass.tmf.ui.properties.ReadOnlyTextPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class TargetNodePropertySource
extends BasePropertySource {
    public static final String TARGET_NODE_NAME_PROPERTY_ID = "target.node.name";
    public static final String TARGET_NODE_ADDRESS_PROPERTY_ID = "target.node.address";
    public static final String TARGET_NODE_STATE_PROPERTY_ID = "target.node.state";
    public static final String TARGET_NODE_VERSION_PROPERTY_ID = "target.node.version";
    public static final String TARGET_NODE_NAME_PROPERTY_NAME = Messages.TraceControl_HostNamePropertyName;
    public static final String TARGET_NODE_ADDRESS_PROPERTY_NAME = Messages.TraceControl_HostAddressPropertyName;
    public static final String TARGET_NODE_STATE_PROPERTY_NAME = Messages.TraceControl_StatePropertyName;
    public static final String TARGET_NODE_VERSION_PROPERTY_NAME = Messages.TraceControl_VersionPropertyName;
    private static final String LOCAL_CONNECTION_HOST_NAME = "localhost";
    private final TargetNodeComponent fTargetNode;

    public TargetNodePropertySource(TargetNodeComponent component) {
        this.fTargetNode = component;
    }

    @Override
    public IPropertyDescriptor[] getPropertyDescriptors() {
        return new IPropertyDescriptor[]{new ReadOnlyTextPropertyDescriptor((Object)TARGET_NODE_NAME_PROPERTY_ID, TARGET_NODE_NAME_PROPERTY_NAME), new ReadOnlyTextPropertyDescriptor((Object)TARGET_NODE_ADDRESS_PROPERTY_ID, TARGET_NODE_ADDRESS_PROPERTY_NAME), new ReadOnlyTextPropertyDescriptor((Object)TARGET_NODE_STATE_PROPERTY_ID, TARGET_NODE_STATE_PROPERTY_NAME), new ReadOnlyTextPropertyDescriptor((Object)TARGET_NODE_VERSION_PROPERTY_ID, TARGET_NODE_VERSION_PROPERTY_NAME)};
    }

    @Override
    public Object getPropertyValue(Object id) {
        if (TARGET_NODE_NAME_PROPERTY_ID.equals(id)) {
            return this.fTargetNode.getName();
        }
        if (TARGET_NODE_ADDRESS_PROPERTY_ID.equals(id)) {
            IRemoteConnection connection = this.fTargetNode.getRemoteSystemProxy().getRemoteConnection();
            if (connection.hasService(IRemoteConnectionHostService.class)) {
                IRemoteConnectionHostService service = (IRemoteConnectionHostService)NonNullUtils.checkNotNull((Object)((IRemoteConnectionHostService)connection.getService(IRemoteConnectionHostService.class)));
                return service.getHostname();
            }
            return LOCAL_CONNECTION_HOST_NAME;
        }
        if (TARGET_NODE_STATE_PROPERTY_ID.equals(id)) {
            return this.fTargetNode.getTargetNodeState().name();
        }
        if (TARGET_NODE_VERSION_PROPERTY_ID.equals(id)) {
            return this.fTargetNode.getNodeVersion();
        }
        return null;
    }
}

