/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model.beans;

import java.util.Locale;
import org.apache.commons.jxpath.JXPathInvalidAccessException;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.compiler.NodeNameTest;
import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.compiler.NodeTypeTest;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.ri.model.beans.BeanAttributeIterator;
import org.apache.commons.jxpath.ri.model.beans.PropertyIterator;
import org.apache.commons.jxpath.ri.model.beans.PropertyPointer;
import org.apache.commons.jxpath.util.ValueUtils;

public abstract class PropertyOwnerPointer
extends NodePointer {
    private static final Object UNINITIALIZED = new Object();
    private Object value = UNINITIALIZED;

    public NodeIterator childIterator(NodeTest test, boolean reverse, NodePointer startWith) {
        if (test == null) {
            return this.createNodeIterator(null, reverse, startWith);
        }
        if (test instanceof NodeNameTest) {
            NodeNameTest nodeNameTest = (NodeNameTest)test;
            QName testName = nodeNameTest.getNodeName();
            if (this.isValidProperty(testName)) {
                return this.createNodeIterator(nodeNameTest.isWildcard() ? null : testName.toString(), reverse, startWith);
            }
            return null;
        }
        return test instanceof NodeTypeTest && ((NodeTypeTest)test).getNodeType() == 1 ? this.createNodeIterator(null, reverse, startWith) : null;
    }

    public NodeIterator createNodeIterator(String property, boolean reverse, NodePointer startWith) {
        return new PropertyIterator(this, property, reverse, startWith);
    }

    public NodeIterator attributeIterator(QName name) {
        return new BeanAttributeIterator(this, name);
    }

    protected PropertyOwnerPointer(NodePointer parent, Locale locale) {
        super(parent, locale);
    }

    protected PropertyOwnerPointer(NodePointer parent) {
        super(parent);
    }

    public void setIndex(int index) {
        if (this.index != index) {
            super.setIndex(index);
            this.value = UNINITIALIZED;
        }
    }

    public Object getImmediateNode() {
        if (this.value == UNINITIALIZED) {
            this.value = this.index == Integer.MIN_VALUE ? ValueUtils.getValue(this.getBaseValue()) : ValueUtils.getValue(this.getBaseValue(), this.index);
        }
        return this.value;
    }

    public abstract QName getName();

    public boolean isValidProperty(QName name) {
        return this.isDefaultNamespace(name.getPrefix());
    }

    public void setValue(Object value) {
        this.value = value;
        if (this.parent != null) {
            if (!this.parent.isContainer()) {
                if (this.index == Integer.MIN_VALUE) {
                    throw new UnsupportedOperationException("Cannot setValue of an object that is not some other object's property");
                }
                throw new JXPathInvalidAccessException("The specified collection element does not exist: " + this);
            }
        } else {
            throw new UnsupportedOperationException("Cannot replace the root object");
        }
        this.parent.setValue(value);
    }

    public void remove() {
        this.value = null;
        if (this.parent == null) {
            throw new UnsupportedOperationException("Cannot remove an object that is not some other object's property or a collection element");
        }
        this.parent.remove();
    }

    public abstract PropertyPointer getPropertyPointer();

    public boolean isDynamicPropertyDeclarationSupported() {
        return false;
    }

    public int compareChildNodePointers(NodePointer pointer1, NodePointer pointer2) {
        int r = pointer1.getName().toString().compareTo(pointer2.getName().toString());
        return r == 0 ? pointer1.getIndex() - pointer2.getIndex() : r;
    }
}

