/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.UndeclaredThrowableException;
import org.apache.lucene.util.Attribute;
import org.apache.lucene.util.AttributeImpl;

public abstract class AttributeFactory {
    private static final MethodHandles.Lookup lookup = MethodHandles.publicLookup();
    private static final MethodType NO_ARG_CTOR = MethodType.methodType(Void.TYPE);
    private static final MethodType NO_ARG_RETURNING_ATTRIBUTEIMPL = MethodType.methodType(AttributeImpl.class);
    public static final AttributeFactory DEFAULT_ATTRIBUTE_FACTORY = new DefaultAttributeFactory();

    public abstract AttributeImpl createAttributeInstance(Class<? extends Attribute> var1) throws UndeclaredThrowableException;

    static final MethodHandle findAttributeImplCtor(Class<? extends AttributeImpl> clazz) {
        try {
            return lookup.findConstructor(clazz, NO_ARG_CTOR).asType(NO_ARG_RETURNING_ATTRIBUTEIMPL);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new IllegalArgumentException("Cannot lookup accessible no-arg constructor for: " + clazz.getName(), e);
        }
    }

    public static <A extends AttributeImpl> AttributeFactory getStaticImplementation(AttributeFactory delegate, Class<A> clazz) {
        final MethodHandle constr = AttributeFactory.findAttributeImplCtor(clazz);
        return new StaticImplementationAttributeFactory<A>(delegate, clazz){

            @Override
            protected A createInstance() {
                try {
                    AttributeImpl impl = constr.invokeExact();
                    return impl;
                }
                catch (Error | RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new UndeclaredThrowableException(e);
                }
            }
        };
    }

    public static abstract class StaticImplementationAttributeFactory<A extends AttributeImpl>
    extends AttributeFactory {
        private final AttributeFactory delegate;
        private final Class<A> clazz;

        protected StaticImplementationAttributeFactory(AttributeFactory delegate, Class<A> clazz) {
            this.delegate = delegate;
            this.clazz = clazz;
        }

        @Override
        public final AttributeImpl createAttributeInstance(Class<? extends Attribute> attClass) {
            return attClass.isAssignableFrom(this.clazz) ? this.createInstance() : this.delegate.createAttributeInstance(attClass);
        }

        protected abstract A createInstance();

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || other.getClass() != this.getClass()) {
                return false;
            }
            StaticImplementationAttributeFactory af = (StaticImplementationAttributeFactory)other;
            return this.delegate.equals(af.delegate) && this.clazz == af.clazz;
        }

        public int hashCode() {
            return 31 * this.delegate.hashCode() + this.clazz.hashCode();
        }
    }

    private static final class DefaultAttributeFactory
    extends AttributeFactory {
        private final ClassValue<MethodHandle> constructors = new ClassValue<MethodHandle>(){

            @Override
            protected MethodHandle computeValue(Class<?> attClass) {
                return AttributeFactory.findAttributeImplCtor(this.findImplClass(attClass.asSubclass(Attribute.class)));
            }
        };

        DefaultAttributeFactory() {
        }

        @Override
        public AttributeImpl createAttributeInstance(Class<? extends Attribute> attClass) {
            try {
                return this.constructors.get(attClass).invokeExact();
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new UndeclaredThrowableException(e);
            }
        }

        private Class<? extends AttributeImpl> findImplClass(Class<? extends Attribute> attClass) {
            try {
                return Class.forName(attClass.getName() + "Impl", true, attClass.getClassLoader()).asSubclass(AttributeImpl.class);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IllegalArgumentException("Cannot find implementing class for: " + attClass.getName(), cnfe);
            }
        }
    }
}

