/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.undo.snapshot;

import java.net.URI;
import org.eclipse.core.internal.resources.undo.snapshot.ContainerSnapshot;
import org.eclipse.core.internal.resources.undo.snapshot.ResourceSnapshotMessages;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResourceFilterDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class FolderSnapshot
extends ContainerSnapshot<IFolder> {
    private boolean virtual = false;

    public FolderSnapshot(IFolder folder, boolean virtual) {
        super(folder);
        this.virtual = virtual;
    }

    public FolderSnapshot(IFolder folder, URI linkLocation) {
        super(folder);
        this.name = folder.getName();
        this.location = linkLocation;
    }

    @Override
    public IFolder createResourceHandle() {
        IWorkspaceRoot workspaceRoot = this.getWorkspace().getRoot();
        IPath folderPath = this.parent.getFullPath().append(this.name);
        return workspaceRoot.getFolder(folderPath);
    }

    @Override
    public void createExistentResourceFromHandle(IProgressMonitor mon) throws CoreException {
        IFolder folderHandle = this.createResourceHandle();
        if (folderHandle.exists()) {
            return;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)mon, (int)300);
        subMonitor.setTaskName(ResourceSnapshotMessages.FolderDescription_NewFolderProgress);
        if (this.filters != null) {
            SubMonitor loopMonitor = subMonitor.split(100).setWorkRemaining(this.filters.length);
            IResourceFilterDescription[] iResourceFilterDescriptionArray = this.filters;
            int n = this.filters.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceFilterDescription filter = iResourceFilterDescriptionArray[n2];
                folderHandle.createFilter(filter.getType(), filter.getFileInfoMatcherDescription(), 0, (IProgressMonitor)loopMonitor.split(1));
                ++n2;
            }
        }
        subMonitor.setWorkRemaining(200);
        if (this.location != null) {
            folderHandle.createLink(this.location, 16, (IProgressMonitor)subMonitor.split(100));
        } else {
            folderHandle.create(this.virtual ? 8192 : 0, true, (IProgressMonitor)subMonitor.split(100));
        }
        this.createChildResources(folderHandle, (IProgressMonitor)subMonitor.split(100));
    }
}

