/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.scripts.expressions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ease.ui.scripts.expressions.IExpressionDefinition;
import org.eclipse.ease.ui.scripts.expressions.definitions.AbstractCompositeExpressionDefinition;
import org.eclipse.ease.ui.scripts.expressions.definitions.AbstractExpressionDefinition;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public final class ExpressionTools {
    private static final String EXTENSION_EXPRESSION_ID = "org.eclipse.ease.ui.scripts.expressions";
    private static final String EXTENSION_DEFINITION_ID = "definition";

    @Deprecated
    private ExpressionTools() {
        throw new UnsupportedOperationException("Utility class shall not be isntantiated.");
    }

    public static Map<String, ExpressionDescription> loadDescriptions() {
        IConfigurationElement[] config;
        HashMap<String, ExpressionDescription> descriptions = new HashMap<String, ExpressionDescription>();
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_EXPRESSION_ID);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            if (EXTENSION_DEFINITION_ID.equals(e.getName())) {
                ExpressionDescription description = new ExpressionDescription(e);
                descriptions.put(description.getName(), description);
            }
            ++n2;
        }
        return descriptions;
    }

    public static IExpressionDefinition parse(String serializedExpression) {
        int startBracketPos = serializedExpression.indexOf(40);
        if (startBracketPos > 0) {
            if (serializedExpression.charAt(serializedExpression.length() - 1) != ')') {
                throw new IllegalArgumentException("Could not find closing bracket");
            }
            String identifier = serializedExpression.substring(0, startBracketPos);
            IExpressionDefinition expression = ExpressionTools.createExpressionDefinition(identifier);
            String content = serializedExpression.substring(startBracketPos + 1, serializedExpression.length() - 1);
            List<String> tokens = ExpressionTools.tokenize(content);
            for (String token : tokens) {
                int equalsPos = token.indexOf(61);
                int bracketPos = token.indexOf(40);
                if (equalsPos > 0 && bracketPos > 0 && equalsPos < bracketPos || equalsPos > 0 && bracketPos == -1) {
                    String key = token.substring(0, equalsPos).trim();
                    String value = token.substring(equalsPos + 1, token.length()).trim();
                    if (!expression.hasParameter(key)) continue;
                    expression.setParameter(key, value);
                    continue;
                }
                if (expression instanceof AbstractCompositeExpressionDefinition) {
                    ((AbstractCompositeExpressionDefinition)expression).addChild(ExpressionTools.parse(token));
                    continue;
                }
                throw new IllegalArgumentException("Child expression not valid for \"" + expression + "\"");
            }
            return expression;
        }
        throw new IllegalArgumentException("Could not find opening bracket");
    }

    public static IExpressionDefinition createExpressionDefinition(String identifier) {
        Map<String, ExpressionDescription> descriptions = ExpressionTools.loadDescriptions();
        if (descriptions.containsKey(identifier)) {
            return descriptions.get(identifier).createExpressionDefinition();
        }
        throw new IllegalArgumentException("Unknown Expression type \"" + identifier + "\"");
    }

    private static List<String> tokenize(String content) {
        ArrayList<String> tokens = new ArrayList<String>();
        int startPos = 0;
        int brackets = 0;
        int index = 0;
        while (index < content.length()) {
            if (content.charAt(index) == '(') {
                ++brackets;
            } else if (content.charAt(index) == ')') {
                --brackets;
            } else if (content.charAt(index) == ',' && brackets == 0) {
                tokens.add(content.substring(startPos, index).trim());
                startPos = index + 1;
            }
            ++index;
        }
        if (startPos < content.length()) {
            tokens.add(content.substring(startPos).trim());
        }
        return tokens;
    }

    public static class ExpressionDescription {
        private final IConfigurationElement fConfigurationElement;

        public ExpressionDescription(IConfigurationElement configurationElement) {
            this.fConfigurationElement = configurationElement;
        }

        public String getName() {
            return this.fConfigurationElement.getAttribute("name");
        }

        public ImageDescriptor getImageDescriptor() {
            String iconLocation = this.fConfigurationElement.getAttribute("icon");
            if (iconLocation != null && !iconLocation.isEmpty()) {
                return AbstractUIPlugin.imageDescriptorFromPlugin((String)this.fConfigurationElement.getContributor().getName(), (String)iconLocation);
            }
            return null;
        }

        public IExpressionDefinition createExpressionDefinition() {
            block11: {
                try {
                    Object candidate = this.fConfigurationElement.createExecutableExtension("class");
                    if (!(candidate instanceof IExpressionDefinition)) break block11;
                    if (candidate instanceof AbstractExpressionDefinition) {
                        ((AbstractExpressionDefinition)candidate).setConfiguration(this.fConfigurationElement);
                    }
                    IConfigurationElement[] iConfigurationElementArray = this.fConfigurationElement.getChildren("parameter");
                    int n = iConfigurationElementArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IConfigurationElement parameterElement = iConfigurationElementArray[n2];
                        ParameterDescription description = new ParameterDescription(parameterElement);
                        ((IExpressionDefinition)candidate).setParameter(description.getName(), description.getDefaultValue());
                        switch (description.getType()) {
                            case "boolean": {
                                ((IExpressionDefinition)candidate).setParameterValues(description.getName(), new String[]{"true", "false"});
                            }
                        }
                        ++n2;
                    }
                    return (IExpressionDefinition)candidate;
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            throw new RuntimeException("Could not create definition for expression");
        }
    }

    private static class ParameterDescription {
        private final IConfigurationElement fConfigurationElement;

        public ParameterDescription(IConfigurationElement configurationElement) {
            this.fConfigurationElement = configurationElement;
        }

        public String getName() {
            return this.fConfigurationElement.getAttribute("name");
        }

        public String getDefaultValue() {
            String defaultValue = this.fConfigurationElement.getAttribute("defaultValue");
            return defaultValue != null ? defaultValue : "";
        }

        public String getType() {
            return this.fConfigurationElement.getAttribute("type");
        }
    }
}

