/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.fused.handlers;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.model.HostThread;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelTrace;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.fused.handlers.FusedVMEventHandlerUtils;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.fused.handlers.IrqEntryHandler;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.fused.handlers.IrqExitHandler;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.fused.handlers.KvmEntryHandler;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.fused.handlers.KvmExitHandler;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.fused.handlers.KvmMmuGetPageHandler;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.fused.handlers.KvmNestedVmExitInjectHandler;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.fused.handlers.PiSetprioHandler;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.fused.handlers.ProcessExitHandler;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.fused.handlers.ProcessForkContainerHandler;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.fused.handlers.ProcessFreeHandler;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.fused.handlers.SchedSwitchHandler;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.fused.handlers.SchedWakeupHandler;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.fused.handlers.SoftIrqEntryHandler;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.fused.handlers.SoftIrqExitHandler;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.fused.handlers.SoftIrqRaiseHandler;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.fused.handlers.StateDumpContainerHandler;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.fused.handlers.SysEntryHandler;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.fused.handlers.SysExitHandler;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.fused.handlers.VMKernelEventHandler;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.model.VirtualCPU;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.model.VirtualMachine;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.model.lxc.LxcModel;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.model.qemukvm.QemuKvmVmModel;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfCpuAspect;
import org.eclipse.tracecompass.tmf.core.statesystem.AbstractTmfStateProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;

public class FusedVirtualMachineStateProvider
extends AbstractTmfStateProvider {
    private static final int VERSION = 2;
    private final Map<String, VMKernelEventHandler> fEventNames;
    private final Map<ITmfTrace, LayoutHandler> fLayouts = new HashMap<ITmfTrace, LayoutHandler>();
    private QemuKvmVmModel fKvmModel;
    private LxcModel fContainerModel;
    private int fCurrentThreadNode;
    private boolean fAllRolesFound = false;
    private final Map<IKernelAnalysisEventLayout, LayoutHandler> fMap = new HashMap<IKernelAnalysisEventLayout, LayoutHandler>();

    private LayoutHandler getForLayout(IKernelAnalysisEventLayout layout, Map<String, VMKernelEventHandler> builder) {
        LayoutHandler layoutHandler = this.fMap.get(layout);
        if (layoutHandler == null) {
            layoutHandler = new LayoutHandler(layout);
            this.fMap.put(layout, layoutHandler);
            this.addEventNames(builder, layout);
        }
        return layoutHandler;
    }

    public FusedVirtualMachineStateProvider(TmfExperiment experiment) {
        super((ITmfTrace)experiment, "Virtual Machine State Provider");
        HashMap<String, VMKernelEventHandler> builder = new HashMap<String, VMKernelEventHandler>();
        for (ITmfTrace trace : TmfTraceManager.getTraceSet((ITmfTrace)experiment)) {
            if (!(trace instanceof IKernelTrace)) continue;
            IKernelAnalysisEventLayout layout = ((IKernelTrace)trace).getKernelEventLayout();
            this.fLayouts.put(trace, this.getForLayout(layout, builder));
        }
        this.fEventNames = ImmutableMap.copyOf(builder);
        this.fKvmModel = QemuKvmVmModel.get(experiment);
        this.fContainerModel = new LxcModel();
    }

    private void addEventNames(Map<String, VMKernelEventHandler> builder, IKernelAnalysisEventLayout layout) {
        builder.put(layout.eventIrqHandlerEntry(), new IrqEntryHandler(layout, this));
        builder.put(layout.eventIrqHandlerExit(), new IrqExitHandler(layout, this));
        builder.put(layout.eventSoftIrqEntry(), new SoftIrqEntryHandler(layout, this));
        builder.put(layout.eventSoftIrqExit(), new SoftIrqExitHandler(layout, this));
        builder.put(layout.eventSoftIrqRaise(), new SoftIrqRaiseHandler(layout, this));
        builder.put(layout.eventSchedSwitch(), new SchedSwitchHandler(layout, this));
        builder.put(layout.eventSchedPiSetprio(), new PiSetprioHandler(layout, this));
        builder.put(layout.eventSchedProcessFork(), new ProcessForkContainerHandler(layout, this));
        builder.put(layout.eventSchedProcessExit(), new ProcessExitHandler(layout, this));
        builder.put(layout.eventSchedProcessFree(), new ProcessFreeHandler(layout, this));
        String eventStatedumpProcessState = layout.eventStatedumpProcessState();
        if (eventStatedumpProcessState != null) {
            builder.put(eventStatedumpProcessState, new StateDumpContainerHandler(layout, this));
        }
        for (String eventSchedWakeup : layout.eventsSchedWakeup()) {
            builder.put(eventSchedWakeup, new SchedWakeupHandler(layout, this));
        }
    }

    public TmfExperiment getTrace() {
        ITmfTrace trace = super.getTrace();
        if (trace instanceof TmfExperiment) {
            return (TmfExperiment)trace;
        }
        throw new IllegalStateException("FusedVirtualMachineStateProvider: The associated trace should be an experiment");
    }

    public int getVersion() {
        return 2;
    }

    public FusedVirtualMachineStateProvider getNewInstance() {
        return new FusedVirtualMachineStateProvider(this.getTrace());
    }

    protected void eventHandle(@Nullable ITmfEvent event) {
        VMKernelEventHandler handler;
        if (event == null) {
            return;
        }
        Integer cpu = TmfTraceUtils.resolveIntEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), TmfCpuAspect.class, (ITmfEvent)event);
        if (cpu == null) {
            return;
        }
        VirtualMachine host = null;
        host = !this.allRolesFound() ? this.getCurrentMachineAndAdd(event) : this.getCurrentMachine(event);
        String traceHost = event.getTrace().getHostId();
        LayoutHandler layoutHandler = this.fLayouts.get(event.getTrace());
        if (layoutHandler == null) {
            return;
        }
        this.fKvmModel.handleEvent(event, layoutHandler.fLayout);
        if (!this.fContainerModel.getRequiredEvents(layoutHandler.fLayout).contains(event.getName()) && !this.allRolesFound()) {
            return;
        }
        Integer currentVCpu = -1;
        if (host != null) {
            VirtualCPU.getVirtualCPU(host, cpu.longValue());
            if (host.isGuest()) {
                currentVCpu = cpu;
                if ((cpu = this.getPhysicalCPU(host, cpu)) == null) {
                    return;
                }
            }
        }
        String eventName = event.getName();
        long ts = event.getTimestamp().getValue();
        ITmfStateSystemBuilder ss = Objects.requireNonNull(this.getStateSystemBuilder());
        if (this.allRolesFound()) {
            int quark;
            Object value;
            int currentCPUNode = ss.getQuarkRelativeAndAdd(FusedVirtualMachineStateProvider.getNodeCPUs(ss), new String[]{String.valueOf(cpu)});
            int quarkCondition = ss.getQuarkRelativeAndAdd(currentCPUNode, new String[]{"Condition"});
            Integer valueCondition = 3;
            int quarkMachines = FusedVMEventHandlerUtils.getMachinesNode(ss);
            int machineHostQuark = ss.getQuarkRelativeAndAdd(quarkMachines, new String[]{traceHost});
            if (host != null && host.isGuest()) {
                valueCondition = 0;
                int quarkVCpu = ss.getQuarkRelativeAndAdd(currentCPUNode, new String[]{"Virtual_cpu"});
                ss.modifyAttribute(ts, (Object)currentVCpu, quarkVCpu);
                ss.getQuarkRelativeAndAdd(machineHostQuark, new String[]{"CPUs", currentVCpu.toString()});
                int quarkPCPUs = FusedVMEventHandlerUtils.getMachinepCPUsNode(ss, traceHost);
                ss.getQuarkRelativeAndAdd(quarkPCPUs, new String[]{cpu.toString()});
            } else {
                ss.getQuarkRelativeAndAdd(quarkMachines, new String[]{traceHost, "CPUs", cpu.toString()});
                valueCondition = 1;
            }
            this.setMachinesRoles(ss);
            this.setMachinesParents(ss);
            if (host != null && host.isHost() && !host.isGuest()) {
                ss.modifyAttribute(ts, (Object)valueCondition, quarkCondition);
            }
            int thread = (value = ss.queryOngoing(quark = ss.getQuarkRelativeAndAdd(currentCPUNode, new String[]{"Current_thread"}))) instanceof Integer ? (Integer)value : -1;
            this.fCurrentThreadNode = ss.getQuarkRelativeAndAdd(FusedVirtualMachineStateProvider.getNodeThreads(ss, traceHost), new String[]{String.valueOf(thread)});
            quark = ss.getQuarkRelativeAndAdd(currentCPUNode, new String[]{"Machine_name"});
            value = event.getTrace().getHostId();
            if (host != null && host.isHost() && !host.isGuest()) {
                ss.modifyAttribute(ts, value, quark);
            }
        }
        if ((handler = this.fEventNames.get(eventName)) == null) {
            IKernelAnalysisEventLayout layout = layoutHandler.fLayout;
            if (FusedVirtualMachineStateProvider.isSyscallExit(eventName, layout)) {
                handler = layoutHandler.fSysExitHandler;
            } else if (FusedVirtualMachineStateProvider.isSyscallEntry(eventName, layout)) {
                handler = layoutHandler.fSysEntryHandler;
            } else if (FusedVirtualMachineStateProvider.isKvmEntry(eventName)) {
                handler = layoutHandler.fKvmEntryHandler;
            } else if (FusedVirtualMachineStateProvider.isKvmExit(eventName)) {
                handler = layoutHandler.fKvmExitHandler;
            } else if (FusedVirtualMachineStateProvider.isKvmMmuGetPage(eventName)) {
                handler = layoutHandler.fKvmMmuGetPageHandler;
            } else if (FusedVirtualMachineStateProvider.isKvmNestedVmExitInject(eventName)) {
                handler = layoutHandler.fKvmNestedVmExitInjectHandler;
            }
        }
        if (handler != null) {
            handler.handleEvent(ss, event);
        }
    }

    private static int getNodeCPUs(ITmfStateSystemBuilder ssb) {
        return ssb.getQuarkAbsoluteAndAdd(new String[]{"CPUs"});
    }

    private static int getNodeThreads(ITmfStateSystemBuilder ssb, String machineName) {
        return ssb.getQuarkAbsoluteAndAdd(new String[]{"Threads", machineName});
    }

    static int getCurrentThreadNode(Integer cpuNumber, ITmfStateSystemBuilder ss) {
        int quark = ss.getQuarkRelativeAndAdd(FusedVMEventHandlerUtils.getCurrentCPUNode(cpuNumber, ss), new String[]{"Current_thread"});
        Object value = ss.queryOngoing(quark);
        int thread = value instanceof Integer ? (Integer)value : -1;
        quark = ss.getQuarkRelativeAndAdd(FusedVMEventHandlerUtils.getCurrentCPUNode(cpuNumber, ss), new String[]{"Machine_name"});
        String machineName = (String)ss.queryOngoing(quark);
        return ss.getQuarkRelativeAndAdd(FusedVirtualMachineStateProvider.getNodeThreads(ss, machineName), new String[]{String.valueOf(thread)});
    }

    private static boolean isSyscallEntry(String eventName, IKernelAnalysisEventLayout layout) {
        return eventName.startsWith(layout.eventSyscallEntryPrefix()) || eventName.startsWith(layout.eventCompatSyscallEntryPrefix());
    }

    private static boolean isSyscallExit(String eventName, IKernelAnalysisEventLayout layout) {
        return eventName.startsWith(layout.eventSyscallExitPrefix()) || eventName.startsWith(layout.eventCompatSyscallExitPrefix());
    }

    int getCurrentThreadNode() {
        return this.fCurrentThreadNode;
    }

    @Nullable Integer getPhysicalCPU(VirtualMachine host, Integer cpu) {
        VirtualCPU vcpu = VirtualCPU.getVirtualCPU(host, cpu.longValue());
        Long physCpu = this.fKvmModel.getPhysicalCpuFromVcpu(host, vcpu);
        if (physCpu == null) {
            return null;
        }
        return physCpu.intValue();
    }

    @Nullable VirtualMachine getCurrentMachineAndAdd(ITmfEvent event) {
        return this.fKvmModel.getCurrentMachine(event);
    }

    @Nullable VirtualMachine getCurrentMachine(ITmfEvent event) {
        return this.getKnownMachines().get(event.getTrace().getHostId());
    }

    @Nullable VirtualMachine getCurrentContainer(ITmfEvent event) {
        return this.fContainerModel.getCurrentMachine(event);
    }

    @Nullable VirtualMachine getVmFromHostThread(HostThread ht) {
        return this.fKvmModel.getVmFromHostThread(ht);
    }

    @Nullable HostThread getHostThreadFromVCpu(VirtualCPU virtualCPU) {
        return this.fKvmModel.getHostThreadFromVCpu(virtualCPU);
    }

    @Nullable VirtualCPU getVirtualCpu(HostThread ht) {
        return this.fKvmModel.getVirtualCpu(ht);
    }

    @Nullable VirtualCPU getVCpuEnteringHypervisorMode(ITmfEvent event, HostThread ht, IKernelAnalysisEventLayout layout) {
        return this.fKvmModel.getVCpuEnteringHypervisorMode(event, ht, layout);
    }

    private static boolean isKvmEntry(String eventName) {
        return eventName.equals("kvm_entry") || eventName.equals("kvm_x86_entry");
    }

    private static boolean isKvmExit(String eventName) {
        return eventName.equals("kvm_exit") || eventName.equals("kvm_x86_exit");
    }

    private static boolean isKvmMmuGetPage(String eventName) {
        return eventName.equals("kvm_mmu_get_page");
    }

    private static boolean isKvmNestedVmExitInject(String eventName) {
        return eventName.equals("kvm_nested_vmexit_inject");
    }

    public Map<String, VirtualMachine> getKnownMachines() {
        return this.fKvmModel.getKnownMachines();
    }

    private boolean allRolesFound() {
        if (this.fAllRolesFound) {
            return this.fAllRolesFound;
        }
        int numberOfMachines = this.numberOfIdentifiedMachines();
        this.fAllRolesFound = this.getTrace().getTraces().size() == numberOfMachines;
        return this.fAllRolesFound;
    }

    private int numberOfIdentifiedMachines() {
        int numberOfMachines = 0;
        for (VirtualMachine machine : this.getKnownMachines().values()) {
            if (!machine.isHost() || machine.isGuest()) continue;
            ++numberOfMachines;
            numberOfMachines += this.numberOfIdentifiedMachinesRec(machine);
        }
        return numberOfMachines;
    }

    private int numberOfIdentifiedMachinesRec(VirtualMachine machine) {
        int nbMachines = 0;
        for (VirtualMachine child : machine.getChildren()) {
            child.setParent(machine);
            ++nbMachines;
            nbMachines += this.numberOfIdentifiedMachinesRec(child);
        }
        return nbMachines;
    }

    private void setMachinesRoles(ITmfStateSystemBuilder ss) {
        Map<String, VirtualMachine> knownMachines = this.getKnownMachines();
        for (VirtualMachine machine : knownMachines.values()) {
            Object machineType;
            String machineHost = machine.getHostId();
            int machineQuark = ss.getQuarkAbsoluteAndAdd(new String[]{"Hosts", machineHost});
            int machineNameQuark = ss.optQuarkRelative(machineQuark, new String[]{"Machine_name"});
            if (machineNameQuark == -2) {
                machineNameQuark = ss.getQuarkRelativeAndAdd(machineQuark, new String[]{"Machine_name"});
                ss.updateOngoingState((Object)machine.getTraceName(), machineNameQuark);
            }
            if ((machineType = ss.queryOngoing(machineQuark)) instanceof Integer) continue;
            ss.updateOngoingState((Object)machine.getType(), machineQuark);
        }
    }

    private void setMachinesParents(ITmfStateSystemBuilder ss) {
        Map<String, VirtualMachine> knownMachines = this.getKnownMachines();
        for (VirtualMachine machine : knownMachines.values()) {
            String machineName = machine.getHostId();
            int parentQuark = ss.getQuarkAbsoluteAndAdd(new String[]{"Hosts", machineName, "Parent"});
            Object parent = ss.queryOngoing(parentQuark);
            if (parent != null) {
                return;
            }
            VirtualMachine parentMachine = machine.getParent();
            if (parentMachine == null) continue;
            ss.modifyAttribute(this.getStartTime(), (Object)parentMachine.getHostId(), parentQuark);
        }
    }

    private class LayoutHandler {
        protected final IKernelAnalysisEventLayout fLayout;
        protected final VMKernelEventHandler fSysEntryHandler;
        protected final VMKernelEventHandler fSysExitHandler;
        protected final VMKernelEventHandler fKvmEntryHandler;
        protected final VMKernelEventHandler fKvmExitHandler;
        protected final VMKernelEventHandler fKvmNestedVmExitInjectHandler;
        protected final VMKernelEventHandler fKvmMmuGetPageHandler;

        public LayoutHandler(IKernelAnalysisEventLayout layout) {
            this.fLayout = layout;
            this.fSysEntryHandler = new SysEntryHandler(layout, FusedVirtualMachineStateProvider.this);
            this.fSysExitHandler = new SysExitHandler(layout, FusedVirtualMachineStateProvider.this);
            this.fKvmEntryHandler = new KvmEntryHandler(layout, FusedVirtualMachineStateProvider.this);
            this.fKvmExitHandler = new KvmExitHandler(layout, FusedVirtualMachineStateProvider.this);
            this.fKvmMmuGetPageHandler = new KvmMmuGetPageHandler(layout, FusedVirtualMachineStateProvider.this);
            this.fKvmNestedVmExitInjectHandler = new KvmNestedVmExitInjectHandler(layout, FusedVirtualMachineStateProvider.this);
        }
    }
}

