/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.build;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.parser.IExtendedScannerInfo;
import org.eclipse.core.resources.IResource;

public class ScannerInfoCache {
    private List<Command> commands;
    private transient Map<List<String>, Command> commandMap = new HashMap<List<String>, Command>();
    private transient Map<String, Command> resourceMap = new HashMap<String, Command>();

    public void initCache() {
        if (this.commands == null) {
            this.commands = new ArrayList<Command>();
        }
        for (Command command : this.commands) {
            this.commandMap.put(command.command, command);
            for (String resourcePath : command.resourcePaths) {
                this.resourceMap.put(resourcePath, command);
            }
        }
    }

    public IExtendedScannerInfo getScannerInfo(IResource resource) {
        String resourcePath = resource.getLocation().toOSString();
        Command command = this.resourceMap.get(resourcePath);
        return command != null ? command.info : null;
    }

    public IExtendedScannerInfo getScannerInfo(List<String> commandStrings) {
        Command command = this.commandMap.get(commandStrings);
        return command != null ? command.info : null;
    }

    public boolean hasCommand(List<String> commandStrings) {
        return this.commandMap.get(commandStrings) != null;
    }

    public void addScannerInfo(List<String> commandStrings, IExtendedScannerInfo info, IResource resource) {
        Command command;
        String resourcePath = resource.getLocation().toOSString();
        Command oldCommand = this.resourceMap.get(resourcePath);
        if (oldCommand != null) {
            if (oldCommand.command.equals(commandStrings)) {
                return;
            }
            oldCommand.resourcePaths.remove(resourcePath);
            if (oldCommand.resourcePaths.isEmpty()) {
                this.commandMap.remove(oldCommand.command);
                this.commands.remove(oldCommand);
                this.resourceMap.remove(resourcePath);
            }
        }
        if ((command = this.commandMap.get(commandStrings)) != null) {
            command.info = info;
            command.resourcePaths.add(resourcePath);
            this.resourceMap.put(resourcePath, command);
        } else {
            command = new Command();
            command.command = commandStrings;
            command.info = info;
            command.resourcePaths = new ArrayList<String>();
            command.resourcePaths.add(resourcePath);
            this.commands.add(command);
            this.commandMap.put(commandStrings, command);
            this.resourceMap.put(resourcePath, command);
        }
    }

    public boolean hasResource(List<String> commandStrings, IResource resource) {
        String resourcePath = resource.getLocation().toOSString();
        Command command = this.commandMap.get(commandStrings);
        if (command == null) {
            return false;
        }
        return command.resourcePaths.contains(resourcePath);
    }

    public void addResource(List<String> commandStrings, IResource resource) {
        String resourcePath = resource.getLocation().toOSString();
        Command command = this.commandMap.get(commandStrings);
        Command current = this.resourceMap.get(resourcePath);
        if (current != null) {
            if (!current.equals(command)) {
                current.resourcePaths.remove(resourcePath);
                if (current.resourcePaths.isEmpty()) {
                    this.commands.remove(current);
                    this.commandMap.remove(current.command);
                }
            } else {
                return;
            }
        }
        command.resourcePaths.add(resource.getLocation().toOSString());
        this.resourceMap.put(resourcePath, command);
    }

    public void removeResource(IResource resource) {
        String resourcePath = resource.getLocation().toOSString();
        Command command = this.resourceMap.get(resourcePath);
        if (command != null) {
            command.resourcePaths.remove(resourcePath);
            if (command.resourcePaths.isEmpty()) {
                this.commands.remove(command);
                this.commandMap.remove(command.command);
            }
            this.resourceMap.remove(resourcePath);
        }
    }

    public void removeCommand(List<String> commandStrings) {
        Command command = this.commandMap.remove(commandStrings);
        if (command != null) {
            this.commands.remove(command);
            for (String resourcePath : command.resourcePaths) {
                Command current = this.resourceMap.get(resourcePath);
                if (!current.equals(command)) continue;
                this.resourceMap.remove(resourcePath);
            }
        }
    }

    private static class Command {
        public List<String> command;
        public IExtendedScannerInfo info;
        public List<String> resourcePaths;

        private Command() {
        }
    }
}

