/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index;

import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorStatement;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.parser.ISignificantMacros;
import org.eclipse.cdt.internal.core.index.CIndex;
import org.eclipse.cdt.internal.core.index.IIndexFragmentFile;
import org.eclipse.cdt.internal.core.index.IWritableIndex;
import org.eclipse.cdt.internal.core.index.IWritableIndexFragment;
import org.eclipse.cdt.internal.core.pdom.ASTFilePathResolver;
import org.eclipse.cdt.internal.core.pdom.FailedToReAcquireLockException;
import org.eclipse.cdt.internal.core.pdom.YieldableIndexLock;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class WritableCIndex
extends CIndex
implements IWritableIndex {
    private boolean fIsWriteLocked;
    private Object fThread;

    public WritableCIndex(IWritableIndexFragment writable) {
        super(new IWritableIndexFragment[]{writable});
    }

    @Override
    public IWritableIndexFragment getWritableFragment() {
        return (IWritableIndexFragment)this.getFragments()[0];
    }

    @Override
    public IIndexFragmentFile getWritableFile(int linkageID, IIndexFileLocation location, ISignificantMacros macroDictionary) throws CoreException {
        return (IIndexFragmentFile)super.getFile(linkageID, location, macroDictionary);
    }

    @Override
    public IIndexFragmentFile[] getWritableFiles(int linkageID, IIndexFileLocation location) throws CoreException {
        return this.getWritableFragment().getFiles(linkageID, location);
    }

    @Override
    public IIndexFragmentFile[] getWritableFiles(IIndexFileLocation location) throws CoreException {
        return this.getWritableFragment().getFiles(location);
    }

    @Override
    public IIndexFragmentFile addFile(int linkageID, IIndexFileLocation location, ISignificantMacros macroDictionary) throws CoreException {
        return this.getWritableFragment().addFile(linkageID, location, macroDictionary);
    }

    @Override
    public IIndexFragmentFile addUncommittedFile(int linkageID, IIndexFileLocation location, ISignificantMacros macroDictionary) throws CoreException {
        return this.getWritableFragment().addUncommittedFile(linkageID, location, macroDictionary);
    }

    @Override
    public IIndexFragmentFile commitUncommittedFile() throws CoreException {
        return this.getWritableFragment().commitUncommittedFile();
    }

    @Override
    public void clearUncommittedFile() throws CoreException {
        this.getWritableFragment().clearUncommittedFile();
    }

    @Override
    public void setFileContent(IIndexFragmentFile file, int linkageID, IWritableIndex.IncludeInformation[] includes, IASTPreprocessorStatement[] macros, IASTName[][] names, ASTFilePathResolver resolver, YieldableIndexLock lock) throws CoreException, FailedToReAcquireLockException {
        assert (this.getWritableFragment() == file.getIndexFragment());
        IWritableIndex.IncludeInformation[] includeInformationArray = includes;
        int n = includes.length;
        int n2 = 0;
        while (n2 < n) {
            IWritableIndex.IncludeInformation include = includeInformationArray[n2];
            if (include.fLocation != null) {
                include.fTargetFile = this.addFile(linkageID, include.fLocation, include.fSignificantMacros);
            }
            ++n2;
        }
        this.getWritableFragment().addFileContent(file, includes, macros, names, resolver, lock);
    }

    @Override
    public void clear() throws CoreException {
        this.getWritableFragment().clear();
    }

    @Override
    public void clearFile(IIndexFragmentFile file) throws CoreException {
        this.getWritableFragment().clearFile(file);
    }

    @Override
    public void acquireReadLock() throws InterruptedException {
        this.checkThread();
        assert (!this.fIsWriteLocked) : "Read locks are not allowed while write-locked.";
        super.acquireReadLock();
    }

    @Override
    public void releaseReadLock() {
        this.checkThread();
        assert (!this.fIsWriteLocked) : "Read locks are not allowed while write-locked.";
        super.releaseReadLock();
        if (this.getReadLockCount() == 0) {
            this.fThread = null;
        }
    }

    @Override
    public void acquireWriteLock(IProgressMonitor monitor) throws InterruptedException {
        this.checkThread();
        assert (!this.fIsWriteLocked) : "Multiple write locks is not allowed";
        this.getWritableFragment().acquireWriteLock(this.getReadLockCount(), monitor);
        this.fIsWriteLocked = true;
    }

    @Override
    public void releaseWriteLock() {
        this.releaseWriteLock(true);
    }

    @Override
    public void releaseWriteLock(boolean flush) {
        this.checkThread();
        assert (this.fIsWriteLocked) : "No write lock to be released";
        int establishReadlockCount = this.getReadLockCount();
        if (establishReadlockCount == 0) {
            this.clearResultCache();
        }
        this.fIsWriteLocked = false;
        this.getWritableFragment().releaseWriteLock(establishReadlockCount, flush);
        if (establishReadlockCount == 0) {
            this.fThread = null;
        }
    }

    private void checkThread() {
        if (this.fThread == null) {
            this.fThread = Thread.currentThread();
        } else if (this.fThread != Thread.currentThread()) {
            throw new IllegalArgumentException("A writable index must not be used from multiple threads.");
        }
    }

    @Override
    public void clearResultCache() {
        assert (this.fIsWriteLocked) : "Need to hold a write lock to clear result caches";
        super.clearResultCache();
    }

    @Override
    public void flush() throws CoreException {
        assert (!this.fIsWriteLocked);
        this.getWritableFragment().flush();
    }

    @Override
    public long getDatabaseSizeBytes() {
        return this.getWritableFragment().getDatabaseSizeBytes();
    }

    @Override
    public void transferIncluders(IIndexFragmentFile source, IIndexFragmentFile target) throws CoreException {
        if (source == null || target == null) {
            throw new IllegalArgumentException();
        }
        if (source.equals(target)) {
            return;
        }
        target.transferIncluders(source);
    }

    @Override
    public void transferContext(IIndexFragmentFile source, IIndexFragmentFile target) throws CoreException {
        if (source == null || target == null) {
            throw new IllegalArgumentException();
        }
        if (source.equals(target)) {
            return;
        }
        target.transferContext(source);
    }
}

