/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.datamodel;

import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.internal.datamodel.DataModelExtensionReader;
import org.eclipse.wst.common.frameworks.internal.datamodel.DataModelImpl;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

public class DataModelFactory {
    private static DataModelExtensionReader reader;

    private DataModelFactory() {
    }

    public static IDataModel createDataModel(String dataModelProviderID) {
        IDataModelProvider provider = DataModelFactory.loadProvider(dataModelProviderID);
        if (provider == null) {
            return null;
        }
        return DataModelFactory.createDataModel(provider);
    }

    private static IDataModelProvider loadProvider(String id) {
        if (reader == null) {
            reader = new DataModelExtensionReader();
        }
        return reader.getProvider(id);
    }

    public static String[] getDataModelProviderIDsForKind(String dataModelProviderKindID) {
        String[] validProviderIDs = DataModelFactory.loadProviderForProviderKind(dataModelProviderKindID);
        return validProviderIDs != null ? validProviderIDs : new String[]{};
    }

    private static String[] loadProviderForProviderKind(String providerKind) {
        if (reader == null) {
            reader = new DataModelExtensionReader();
        }
        return reader.getProviderDescriptorsForProviderKind(providerKind);
    }

    public static IDataModel createDataModel(Class aClass) {
        if (aClass.isInterface()) {
            try {
                Class clazz = (Class)aClass.getField("_provider_class").get(null);
                if (clazz != null) {
                    IDataModelProvider provider = (IDataModelProvider)clazz.newInstance();
                    return DataModelFactory.createDataModel(provider);
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (IllegalArgumentException e) {
                WTPCommonPlugin.logError(e);
            }
            catch (SecurityException e) {
                WTPCommonPlugin.logError(e);
            }
            catch (IllegalAccessException e) {
                WTPCommonPlugin.logError(e);
            }
            catch (InstantiationException e) {
                WTPCommonPlugin.logError(e);
            }
        }
        return DataModelFactory.createDataModel(aClass.getName());
    }

    public static IDataModel createDataModel(IDataModelProvider provider) {
        if (provider == null) {
            throw new NullPointerException();
        }
        DataModelImpl dataModel = new DataModelImpl(provider);
        return dataModel;
    }
}

