/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros.ui.views.messageflow;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.tracecompass.incubator.internal.ros.ui.views.messageflow.Messages;
import org.eclipse.tracecompass.tmf.core.dataprovider.X11ColorUtils;
import org.eclipse.tracecompass.tmf.core.model.StyleProperties;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.StateItem;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;

public class RosMessageFlowPresentationProvider
extends TimeGraphPresentationProvider {
    private static String ARROW_STATE = "arrow";
    private static final StateItem[] STATE_TABLE = new StateItem[State.values().length];

    static {
        int i = 0;
        while (i < STATE_TABLE.length) {
            State state = State.values()[i];
            RGB stateColor = state.rgb;
            String stateType = state.name().toLowerCase().contains(ARROW_STATE) ? StyleProperties.linkType() : StyleProperties.stateType();
            ImmutableMap styleMap = ImmutableMap.of((Object)"background-color", (Object)X11ColorUtils.toHexColor((int)stateColor.red, (int)stateColor.green, (int)stateColor.blue), (Object)"style-name", (Object)String.valueOf(state.toString()), (Object)StyleProperties.itemTypeProperty(), (Object)stateType);
            RosMessageFlowPresentationProvider.STATE_TABLE[i] = new StateItem((Map)styleMap);
            ++i;
        }
    }

    public RosMessageFlowPresentationProvider() {
        super("");
    }

    public int getStateTableIndex(ITimeEvent event) {
        if (event instanceof TimeEvent && ((TimeEvent)event).hasValue()) {
            return ((TimeEvent)event).getValue();
        }
        return -2;
    }

    public StateItem[] getStateTable() {
        return STATE_TABLE;
    }

    public @Nullable String getEventName(ITimeEvent event) {
        if (event instanceof TimeEvent) {
            TimeEvent ev = (TimeEvent)event;
            return ev.getLabel();
        }
        return Messages.RosMessageFlowPresentationProvider_MultipleStates;
    }

    public @Nullable Map<String, String> getEventHoverToolTipInfo(ITimeEvent event) {
        return super.getEventHoverToolTipInfo(event);
    }

    public static enum State {
        PUB_QUEUE_SEGMENT(new RGB(60, 180, 75)),
        SUB_QUEUE_SEGMENT(new RGB(67, 99, 216)),
        CALLBACK_SEGMENT(new RGB(245, 130, 49)),
        UNKNOWN_SEGMENT(new RGB(64, 59, 51)),
        NETWORK_ARROW(new RGB(38, 38, 38)),
        CALLBACK_SCHEDULING_ARROW(new RGB(102, 102, 102)),
        PUBLISH_ARROW(new RGB(166, 166, 166)),
        UNKNOWN_ARROW(new RGB(204, 204, 204));

        public final RGB rgb;

        private State(RGB rgb) {
            this.rgb = rgb;
        }
    }
}

