/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.types;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.tracecompass.ctf.core.event.types.AbstractArrayDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.CompoundDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.Definition;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDefinition;

@NonNullByDefault
public final class ByteArrayDefinition
extends AbstractArrayDefinition {
    private final byte[] fContent;
    private transient @Nullable List<Definition> fDefs;

    public ByteArrayDefinition(CompoundDeclaration declaration, @Nullable IDefinitionScope definitionScope, String fieldName, byte[] content) {
        super(declaration, definitionScope, fieldName);
        this.fContent = content;
    }

    @Override
    public int getLength() {
        return this.fContent.length;
    }

    @Override
    public synchronized List<Definition> getDefinitions() {
        List<Definition> defs = this.fDefs;
        if (defs == null) {
            ImmutableList.Builder builder = new ImmutableList.Builder();
            int i = 0;
            while (i < this.fContent.length) {
                IntegerDeclaration charDecl = IntegerDeclaration.UINT_8_DECL;
                String fieldName = this.getFieldName() + "[" + i + "]";
                byte fieldValue = this.fContent[i];
                builder.add((Object)new IntegerDefinition(charDecl, this.getDefinitionScope(), fieldName, fieldValue));
                ++i;
            }
            this.fDefs = builder.build();
            return this.fDefs;
        }
        return defs;
    }

    @Override
    public String toString() {
        CompoundDeclaration compoundDeclaration = (CompoundDeclaration)this.getDeclaration();
        if (compoundDeclaration.isString()) {
            int pos = -1;
            int i = 0;
            while (i < this.fContent.length) {
                if (this.fContent[i] == 0) {
                    pos = i;
                    break;
                }
                ++i;
            }
            byte[] bytes = pos != -1 ? Arrays.copyOf(this.fContent, pos) : this.fContent;
            return new String(bytes);
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        IDeclaration elementType = compoundDeclaration.getElementType();
        boolean isHex = false;
        if (elementType instanceof IntegerDeclaration) {
            IntegerDeclaration integerDeclaration = (IntegerDeclaration)elementType;
            isHex = integerDeclaration.getBase() == 16;
        }
        ArrayList<String> elements = new ArrayList<String>();
        if (isHex) {
            byte[] byArray = this.fContent;
            int n = this.fContent.length;
            int n2 = 0;
            while (n2 < n) {
                byte element = byArray[n2];
                elements.add(String.format("0x%02X", element));
                ++n2;
            }
        } else {
            byte[] byArray = this.fContent;
            int n = this.fContent.length;
            int n3 = 0;
            while (n3 < n) {
                byte element = byArray[n3];
                elements.add(String.format("%d", element));
                ++n3;
            }
        }
        Joiner.on((String)", ").appendTo(b, elements);
        b.append(']');
        return b.toString();
    }

    public byte getByte(int index) {
        return this.fContent[index];
    }
}

